"""
Script pour vider toutes les données des wallets (sauf l'admin)
"""
import sys
import os
sys.path.append(os.path.dirname(os.path.abspath(__file__)))

from database import SessionLocal
from models.models import Wallet, User

print("\n" + "="*60)
print("SUPPRESSION DES WALLETS (SAUF ADMIN)")
print("="*60)

db = SessionLocal()

try:
    # Récupérer l'utilisateur admin
    admin = db.query(User).filter(User.phone == "0769989178").first()
    
    if not admin:
        print("⚠️  Utilisateur admin non trouvé!")
        admin_id = None
    else:
        admin_id = admin.id
        print(f"✅ Admin trouvé: {admin.email} (ID: {admin_id})")
    
    # Compter les wallets avant suppression
    count_before = db.query(Wallet).count()
    print(f"\n📊 Nombre de wallets avant: {count_before}")
    
    if count_before == 0:
        print("✅ La table wallets est déjà vide!")
    else:
        # Supprimer tous les wallets sauf celui de l'admin
        if admin_id:
            deleted = db.query(Wallet).filter(Wallet.user_id != admin_id).delete()
            print(f"🗑️  {deleted} wallet(s) supprimé(s) (admin préservé)")
        else:
            deleted = db.query(Wallet).delete()
            print(f"🗑️  {deleted} wallet(s) supprimé(s)")
        
        db.commit()
        
        # Vérifier après suppression
        count_after = db.query(Wallet).count()
        print(f"📊 Nombre de wallets après: {count_after}")
        
        if admin_id and count_after == 1:
            print("\n✅ Wallets vidés avec succès (admin préservé)!")
        elif not admin_id and count_after == 0:
            print("\n✅ Tous les wallets supprimés!")
        else:
            print(f"\n⚠️  Il reste {count_after} wallet(s)")
    
    print("="*60 + "\n")
    
except Exception as e:
    print(f"\n❌ Erreur: {str(e)}")
    db.rollback()
finally:
    db.close()
