import { defineConfig } from "vite";
import react from "@vitejs/plugin-react";
const BASE_URL = "https://appteamcash.com";
// https://vitejs.dev/config/
export default defineConfig({
  plugins: [react()],
  server: {
    port: 5173,
    host: true,
    hmr: {
      port: 5173,
    },
    proxy: {
      "/uploads": {
        target: `${BASE_URL}`,
        changeOrigin: true,
      },
    },
  },
  build: {
    // Configuration pour la production
    outDir: "dist",
    sourcemap: false,
    minify: "terser",
    rollupOptions: {
      output: {
        manualChunks: {
          vendor: ["react", "react-dom"],
          router: ["react-router-dom"],
        },
      },
    },
  },
  optimizeDeps: {
    exclude: ["lucide-react"],
  },
  // Configuration pour éviter les problèmes de CSP
  define: {
    "process.env.NODE_ENV": JSON.stringify(
      process.env.NODE_ENV || "development"
    ),
  },
});
