@echo off
echo 🚀 TIM CASH - Démarrage Complet du Système
echo =============================================

echo.
echo 📋 Vérification de la configuration...

REM Vérifier que la base de données existe
if not exist "backend\timcash.db" (
    echo ❌ Base de données timcash.db non trouvée !
    echo 💡 Création de la base de données...
    cd backend
    python simple_extend_sqlite.py
    cd ..
)

echo ✅ Base de données SQLite prête

echo.
echo 🔧 Démarrage du Backend (Port 8001)...
cd backend
start "TIM CASH Backend" cmd /k "python -m uvicorn main:app --reload --port 8001"
cd ..

echo ⏳ Attente du démarrage du backend...
timeout /t 3 /nobreak >nul

echo.
echo 🎨 Démarrage du Frontend React...
start "TIM CASH Frontend" cmd /k "npm run dev"

echo ⏳ Attente du démarrage du frontend...
timeout /t 3 /nobreak >nul

echo.
echo 🎉 TIM CASH Démarré avec Succès !
echo.
echo 📋 URLs Disponibles:
echo    🔗 Frontend: http://localhost:5173 (ou port auto)
echo    🔗 Backend API: http://localhost:8001
echo    🔗 Documentation API: http://localhost:8001/docs
echo    🔗 Base de données: SQLite (timcash.db)
echo.
echo 👤 Compte Admin:
echo    📧 Email: admin@timcash.ci
echo    🔑 Password: admin123
echo.
echo 💰 Stock Admin: 847M FCFA
echo 📊 Tables: 35+ tables étendues
echo.
echo ⚠️ Appuyez sur une touche pour continuer...
pause >nul

echo.
echo 🌐 Ouverture des URLs dans le navigateur...
start http://localhost:8001/docs
timeout /t 2 /nobreak >nul
start http://localhost:5173

echo.
echo 🎯 Système TIM CASH complètement opérationnel !
echo 📋 Fermez cette fenêtre quand vous avez terminé.
pause
