// TIM CASH - Palette de couleurs marron doré inspirée des logos
export const timColors = {
  // Couleurs principales marron doré
  primary: {
    50: '#fdf8f3',
    100: '#faf0e4',
    200: '#f4ddc4',
    300: '#ecc49b',
    400: '#e2a56f',
    500: '#d4874a', // Marron doré principal
    600: '#c06d3a',
    700: '#a05532',
    800: '#82442f',
    900: '#6a3a29',
    950: '#391d15'
  },
  
  // Couleurs secondaires dorées
  gold: {
    50: '#fffdf2',
    100: '#fffae0',
    200: '#fff3b8',
    300: '#ffe885',
    400: '#ffd642',
    500: '#ffbf00', // Or principal
    600: '#e6a600',
    700: '#cc9400',
    800: '#b38200',
    900: '#996f00',
    950: '#664a00'
  },
  
  // Couleurs d'accent cuivre
  copper: {
    50: '#fef7f0',
    100: '#fdeee0',
    200: '#fad9bf',
    300: '#f6be94',
    400: '#f19968',
    500: '#ed7844', // Cuivre principal
    600: '#de5f2a',
    700: '#b94b20',
    800: '#943d20',
    900: '#78341e',
    950: '#41190d'
  },
  
  // Couleurs neutres chaudes
  warm: {
    50: '#fafaf9',
    100: '#f5f5f4',
    200: '#e7e5e4',
    300: '#d6d3d1',
    400: '#a8a29e',
    500: '#78716c',
    600: '#57534e',
    700: '#44403c',
    800: '#292524',
    900: '#1c1917',
    950: '#0c0a09'
  },
  
  // Couleurs de statut avec teinte chaude
  success: {
    50: '#f0fdf4',
    100: '#dcfce7',
    200: '#bbf7d0',
    300: '#86efac',
    400: '#4ade80',
    500: '#22c55e',
    600: '#16a34a',
    700: '#15803d',
    800: '#166534',
    900: '#14532d'
  },
  
  warning: {
    50: '#fffbeb',
    100: '#fef3c7',
    200: '#fde68a',
    300: '#fcd34d',
    400: '#fbbf24',
    500: '#f59e0b',
    600: '#d97706',
    700: '#b45309',
    800: '#92400e',
    900: '#78350f'
  },
  
  error: {
    50: '#fef2f2',
    100: '#fee2e2',
    200: '#fecaca',
    300: '#fca5a5',
    400: '#f87171',
    500: '#ef4444',
    600: '#dc2626',
    700: '#b91c1c',
    800: '#991b1b',
    900: '#7f1d1d'
  }
};

// Gradients marron doré
export const timGradients = {
  primary: 'from-amber-600 via-orange-600 to-amber-700',
  primaryLight: 'from-amber-50 via-orange-50 to-amber-100',
  gold: 'from-yellow-400 via-amber-500 to-orange-600',
  goldLight: 'from-yellow-50 via-amber-50 to-orange-50',
  copper: 'from-orange-500 via-red-500 to-orange-600',
  copperLight: 'from-orange-50 via-red-50 to-orange-100',
  warm: 'from-stone-100 via-amber-50 to-orange-50',
  dark: 'from-amber-900 via-orange-900 to-red-900'
};

// Classes Tailwind personnalisées
export const timClasses = {
  // Backgrounds
  bgPrimary: 'bg-gradient-to-br from-amber-600 via-orange-600 to-amber-700',
  bgPrimaryLight: 'bg-gradient-to-br from-amber-50 via-orange-50 to-amber-100',
  bgGold: 'bg-gradient-to-br from-yellow-400 via-amber-500 to-orange-600',
  bgWarm: 'bg-gradient-to-br from-stone-100 via-amber-50 to-orange-50',
  
  // Textes
  textPrimary: 'text-amber-700',
  textGold: 'text-amber-600',
  textWarm: 'text-stone-700',
  textLight: 'text-amber-50',
  
  // Bordures
  borderPrimary: 'border-amber-300',
  borderGold: 'border-amber-400',
  borderWarm: 'border-stone-300',
  
  // Ombres
  shadowPrimary: 'shadow-amber-200/50',
  shadowGold: 'shadow-amber-300/50',
  shadowWarm: 'shadow-stone-200/50',
  
  // Effets de lueur
  glowPrimary: 'shadow-amber-500/30',
  glowGold: 'shadow-yellow-500/30',
  glowCopper: 'shadow-orange-500/30'
};

export default timColors;
