# 📋 SYSTÈME DE COMMISSIONS ET REMBOURSEMENT AUTOMATIQUE DE PRÊTS

## 📅 Date de mise en œuvre
**Date:** 2024-01-XX

---

## 🎯 OBJECTIFS

Ce document décrit les deux systèmes implémentés :

1. **Système de commissions sur les recharges** - Gestion correcte des commissions TIM CASH et CinetPay
2. **Système de remboursement automatique de prêts** - Déduction automatique lors des recharges et blocage de compte

---

## 💰 1. SYSTÈME DE COMMISSIONS SUR LES RECHARGES

### 📊 Principe

Il existe **DEUX types de commissions distinctes** :

1. **Commission TIM CASH** (2%) - Ajoutée au montant demandé par le client
2. **Commission CinetPay** (variable selon opérateur) - Déduite automatiquement par l'API CinetPay

### 🏦 Opérateurs Mobile Money

CinetPay gère automatiquement les commissions variables selon l'opérateur choisi par le client :
- **Wave** : X% (géré par CinetPay)
- **Orange Money** : Y% (géré par CinetPay)
- **Moov Money** : Z% (géré par CinetPay)
- **MTN Mobile Money** : W% (géré par CinetPay)

**Important:** Ces pourcentages sont gérés automatiquement par l'API CinetPay et varient selon l'opérateur. Le système TIM CASH reçoit le montant APRÈS déduction de la commission CinetPay.

### 🔄 Flux de Paiement

```
Client veut recharger: 10 000 FCFA
    ↓
TIM CASH ajoute sa commission (2%): +200 FCFA
    ↓
Montant à payer: 10 200 FCFA
    ↓
Client paie 10 200 FCFA via Mobile Money (Wave/Orange/Moov/MTN)
    ↓
CinetPay déduit SA commission (variable selon opérateur)
    Exemple: -102 FCFA pour Wave
    ↓
TIM CASH reçoit: 10 098 FCFA (montant réel dans le callback)
    ↓
Système crédite: 10 098 FCFA au wallet
```

### 💡 Exemple Concret

| Étape | Montant | Description |
|-------|---------|-------------|
| Montant souhaité | 10 000 FCFA | Ce que le client veut sur son wallet |
| Commission TIM CASH (2%) | +200 FCFA | Ajoutée par notre système |
| **Total à payer** | **10 200 FCFA** | Montant que le client paie |
| Commission CinetPay (variable) | -102 FCFA | Déduite automatiquement par CinetPay |
| **Montant reçu par TIM CASH** | **10 098 FCFA** | Montant réel dans le callback |
| **Montant crédité au wallet** | **10 098 FCFA** | Ce que le client reçoit effectivement |

### 📁 Fichiers Modifiés

1. **`services/commission_service.py`**
   - `get_recharge_commission_rates()` - Retourne uniquement le taux TIM CASH
   - `calculate_commissions()` - Calcule les deux commissions séparément

2. **`services/transactions.py`**
   - `wallet_transaction()` - Utilise la nouvelle logique de commission
   - Envoie `amount_to_cinetpay` (montant + commission TIM CASH) à CinetPay

3. **`api/v1/route_commission.py`**
   - `/admin/commission-rates/recharge-breakdown` - Endpoint de simulation

4. **`main.py`**
   - Callback CinetPay mis à jour pour gérer les commissions correctement

---

## 🏦 2. SYSTÈME DE REMBOURSEMENT AUTOMATIQUE DE PRÊTS

### 📊 Principe

Lorsqu'un client a un prêt actif non remboursé, **toute recharge de wallet déclenche un remboursement automatique**.

### 💸 Calcul du Montant Dû

```
Montant du prêt + Intérêt de 6%
```

**Exemple:**
- Prêt de 5 000 FCFA
- Intérêt 6% = 300 FCFA
- **Montant total dû = 5 300 FCFA**

### 🔄 Logique de Remboursement

#### **CAS 1: Recharge ≥ Montant Dû (Remboursement Complet)**

```
Prêt dû: 5 300 FCFA
Recharge: 10 000 FCFA
    ↓
Déduction automatique: -5 300 FCFA
    ↓
Wallet crédité: 4 700 FCFA
Prêt: REMBOURSÉ ✅
Compte: DÉBLOQUÉ 🔓
```

#### **CAS 2: Recharge < Montant Dû (Remboursement Partiel)**

```
Prêt dû: 5 300 FCFA
Recharge: 2 000 FCFA
    ↓
Déduction automatique: -2 000 FCFA
    ↓
Wallet crédité: 0 FCFA
Prêt restant: 3 300 FCFA
Prêt: ACTIF ⚠️
Compte: RESTE BLOQUÉ 🔒
```

### ⏰ Délai de Remboursement et Blocage de Compte

#### **Timeline:**

```
Jour 0: Prêt accordé
    ↓
Jour 1-2: Délai de grâce (2 jours)
    ↓
Jour 3: BLOCAGE AUTOMATIQUE si non remboursé 🔒
```

#### **Compte Bloqué:**

- ❌ **Interdit:** Transferts, paiements, transactions NFC, Mobile Money
- ✅ **Autorisé:** Recharges de wallet uniquement (pour rembourser)

#### **Déblocage Automatique:**

Dès que le prêt est **totalement remboursé**, le compte est **automatiquement débloqué**.

### 📁 Fichiers Créés/Modifiés

#### **Nouveaux Fichiers:**

1. **`services/loan_auto_repayment.py`**
   - `LoanAutoRepaymentService` - Service principal
   - `process_auto_repayment()` - Traite le remboursement lors d'une recharge
   - `check_and_block_overdue_accounts()` - Vérifie et bloque les comptes en retard
   - `unblock_account_after_repayment()` - Débloque après remboursement complet

2. **`middleware/account_blocking.py`**
   - `check_account_blocked()` - Middleware pour bloquer les transactions

3. **`cron_check_overdue_loans.py`**
   - Script cron pour vérifier quotidiennement les prêts en retard

4. **`add_user_blocking_fields.py`**
   - Script de migration pour ajouter les champs `is_blocked` et `blocked_reason`

5. **`test_loan_auto_repayment.py`**
   - Tests automatisés du système

#### **Fichiers Modifiés:**

1. **`models.py`**
   - Ajout de `is_blocked` et `blocked_reason` au modèle `User`

2. **`main.py`**
   - Callback CinetPay intégré avec le remboursement automatique
   - Endpoint `/wallet/transfer` avec vérification de blocage

3. **`services/transactions.py`**
   - `wallet_transaction()` - Vérifie le prêt actif avant recharge
   - `encaissement_safe()` - Vérifie si le client est bloqué

4. **`api/v1/route_nfc_transaction.py`**
   - Paiements NFC bloqués si compte bloqué

5. **`api/v1/route_mobile_money.py`**
   - Transferts Mobile Money bloqués si compte bloqué

---

## 🚀 DÉPLOIEMENT

### 1. Migration de la Base de Données

```bash
cd frontnew/backend
python add_user_blocking_fields.py
```

### 2. Configuration du Cron Job

Ajouter au crontab pour vérifier quotidiennement les prêts en retard :

```bash
# Vérifier les prêts en retard tous les jours à minuit
0 0 * * * cd /path/to/frontnew/backend && python cron_check_overdue_loans.py
```

### 3. Tests

```bash
cd frontnew/backend
python test_loan_auto_repayment.py
```

---

## 🧪 TESTS

### Test 1: Remboursement Complet

```python
# Prêt: 5 000 FCFA (5 300 FCFA avec intérêt)
# Recharge: 10 000 FCFA
# Résultat attendu:
#   - Prêt remboursé: 5 300 FCFA
#   - Wallet crédité: 4 700 FCFA
#   - Statut prêt: COMPLETED
#   - Compte: DÉBLOQUÉ
```

### Test 2: Remboursement Partiel

```python
# Prêt: 5 000 FCFA (5 300 FCFA avec intérêt)
# Recharge: 2 000 FCFA
# Résultat attendu:
#   - Prêt remboursé: 2 000 FCFA
#   - Wallet crédité: 0 FCFA
#   - Prêt restant: 3 300 FCFA
#   - Statut prêt: APPROVED/ACTIVE
#   - Compte: RESTE BLOQUÉ
```

### Test 3: Blocage de Compte

```python
# Prêt en retard (échéance dépassée)
# Résultat attendu:
#   - Compte bloqué: True
#   - Raison: "Prêt en retard de X jour(s)"
#   - Transactions bloquées (sauf recharges)
```

---

## 📊 FLUX COMPLET DE RECHARGE AVEC PRÊT ACTIF

```
1. Client demande recharge de 10 000 FCFA
    ↓
2. Système vérifie si prêt actif
    ↓
3. Prêt actif détecté: 5 300 FCFA dû
    ↓
4. Calcul commission TIM CASH (2%): +200 FCFA
    ↓
5. Client paie 10 200 FCFA via CinetPay
    ↓
6. CinetPay déduit sa commission (~1%): -102 FCFA
    ↓
7. Callback reçu: 10 000 FCFA à créditer
    ↓
8. Remboursement automatique: -5 300 FCFA
    ↓
9. Wallet crédité: 4 700 FCFA
    ↓
10. Prêt marqué COMPLETED
    ↓
11. Compte débloqué automatiquement
```

---

## 🔐 SÉCURITÉ

### Endpoints Protégés

Les endpoints suivants vérifient si le compte est bloqué :

- ✅ `/wallet/transfer` - Transferts entre comptes
- ✅ `/financials/encaissement/nfc` - Encaissements NFC
- ✅ `/nfc-transactions/payment` - Paiements NFC
- ✅ `/mobile-money/transfer` - Transferts Mobile Money

### Endpoints Autorisés (Compte Bloqué)

- ✅ `/financials/wallet-paiements/transaction_cinetpay` - Recharges uniquement

---

## 📈 STATISTIQUES ET MONITORING

### Logs à Surveiller

```python
# Remboursement automatique
💳 Remboursement automatique de prêt:
   • Prêt ID: xxx
   • Montant dû: 5300 FCFA
   • Montant recharge: 10000 FCFA
   ✅ Remboursement COMPLET
   • Montant remboursé: 5300 FCFA
   • Montant crédité au wallet: 4700 FCFA

# Blocage de compte
🔒 Compte bloqué: user@example.com
   • Prêt ID: xxx
   • Jours de retard: 3
   • Montant dû: 5300 FCFA
```

---

## ❓ FAQ

### Q: Que se passe-t-il si le client a plusieurs prêts actifs ?

**R:** Le système traite le premier prêt actif trouvé. Une fois remboursé, le prochain prêt sera traité lors de la prochaine recharge.

### Q: Le client peut-il faire des recharges partielles ?

**R:** Oui ! Le client peut faire autant de recharges partielles que nécessaire. Chaque recharge réduit le solde du prêt jusqu'à remboursement complet.

### Q: Que se passe-t-il si le compte est bloqué et le client essaie de faire un transfert ?

**R:** Le système retourne une erreur HTTP 403 avec le message :
```json
{
  "error": "ACCOUNT_BLOCKED",
  "message": "Votre compte est bloqué. Vous ne pouvez effectuer que des recharges pour rembourser votre prêt.",
  "reason": "Prêt en retard de X jour(s). Montant dû: XXXX FCFA",
  "action_required": "Rechargez votre wallet pour rembourser votre prêt et débloquer votre compte."
}
```

---

## ✅ CHECKLIST DE DÉPLOIEMENT

- [ ] Migration base de données exécutée
- [ ] Cron job configuré
- [ ] Tests automatisés passés
- [ ] Backend redémarré
- [ ] Logs vérifiés
- [ ] Test manuel effectué
- [ ] Documentation partagée avec l'équipe

---

**Fin du document**

