# 🚀 Guide de Démarrage TIM CASH - Système Complet

## 📋 Prérequis

✅ **Backend migré** - Base de données SQLAlchemy opérationnelle  
✅ **Serveur API actif** - http://localhost:8001  
✅ **Frontend React** - Prêt à être connecté  

## 🔧 Démarrage Rapide

### 1. Backend (Déjà actif)
```bash
cd backend
python -m uvicorn main:app --reload --port 8001
```
**Status**: ✅ Serveur actif sur http://localhost:8001

### 2. Frontend React
```bash
cd c:\frontnew
npm install
npm run dev
```
**URL attendue**: http://localhost:5173

## 🔗 Configuration de l'Intégration

### Backend API Endpoints
Le backend expose maintenant tous les endpoints nécessaires :

#### Authentification
- `POST /auth/login` - Connexion utilisateur
- `POST /auth/register` - Inscription
- `GET /auth/me` - Profil utilisateur

#### Portefeuille
- `GET /wallet/balance` - Solde du portefeuille
- `POST /wallet/reload` - Recharge CinetPay
- `POST /wallet/transfer` - Transfert entre comptes

#### Administration
- `GET /admin/stock` - Stock administrateur
- `GET /admin/users` - Liste des utilisateurs
- `GET /admin/dashboard-stats` - Statistiques dashboard

#### Prêts
- `POST /loans/create` - Demande de prêt SOS
- `GET /loans/active` - Prêts actifs

#### Géographie
- `GET /countries` - Pays et villes

### Frontend Configuration

Vérifiez que votre frontend utilise la bonne URL d'API :

```typescript
// src/config/api.ts ou équivalent
const API_BASE_URL = "http://localhost:8001";
```

## 👥 Comptes de Test Disponibles

### 🔑 Administrateur
- **Email**: `admin@timcash.ci`
- **Mot de passe**: `admin123`
- **Type**: TIM_BUSINESS (Admin)
- **Solde**: 12,847,000 FCFA
- **Accès**: Dashboard admin complet

### 👤 Utilisateurs Test

#### Marie Kouassi (TIM_MAXI)
- **Email**: `marie.kouassi@timcash.ci`
- **Mot de passe**: `password123`
- **Solde**: 2,847,000 FCFA
- **Limite**: 12M FCFA
- **Prêts**: Jusqu'à 10K FCFA

#### Jean Baptiste (TIM_MINI)
- **Email**: `jean.baptiste@timcash.ci`
- **Mot de passe**: `password123`
- **Solde**: 125,000 FCFA
- **Limite**: 500K FCFA
- **Prêts**: Non autorisés

#### Fatou Diallo (TIM_BUSINESS)
- **Email**: `fatou.diallo@timcash.ci`
- **Mot de passe**: `password123`
- **Solde**: 5,500,000 FCFA
- **Limite**: Illimitée
- **Prêts**: Jusqu'à 50K FCFA

## 🧪 Tests d'Intégration

### Test 1: Connexion Admin
1. Démarrer le frontend
2. Aller à la page de connexion
3. Se connecter avec `admin@timcash.ci` / `admin123`
4. Vérifier l'accès au dashboard admin

### Test 2: Dashboard Admin
- ✅ Stock Admin: 847M FCFA
- ✅ Utilisateurs: 4 total
- ✅ Pays: Côte d'Ivoire, Sénégal
- ✅ Villes: 5 branches

### Test 3: Fonctionnalités Utilisateur
1. Se connecter avec Marie (TIM_MAXI)
2. Vérifier le solde: 2,847,000 FCFA
3. Tester une demande de prêt (max 10K)
4. Vérifier les transactions

### Test 4: Transferts
1. Se connecter avec Fatou (TIM_BUSINESS)
2. Effectuer un transfert vers Marie
3. Vérifier les frais de transfert (1%)
4. Confirmer la réception

## 📊 Données Disponibles

### 🌍 Pays et Villes
- **🇨🇮 Côte d'Ivoire**: Abidjan, Yamoussoukro, Bouaké
- **🇸🇳 Sénégal**: Dakar, Thiès

### 💰 Taux de Commission
- **Recharge CinetPay**: 0.5%
- **Transfert**: 1.0%
- **Retrait**: 2.0%
- **Prêt SOS**: 6.0% intérêts + 15.0% pénalité

### 📱 Analytics NFC
- **Samsung Galaxy A54**: 98.7% succès
- **iPhone 14**: 95.2% succès
- **Tecno Spark 10**: 89.4% succès
- **Redmi Note 12**: 97.1% succès
- **Infinix Note 30**: 91.8% succès

## 🔍 Vérifications

### Backend Health Check
```bash
curl http://localhost:8001/
```
**Réponse attendue**: `{"message": "TIM CASH API v2.0 - Database Edition"}`

### Database Check
```bash
cd backend
python test_db.py
```

### API Documentation
- **Swagger UI**: http://localhost:8001/docs
- **ReDoc**: http://localhost:8001/redoc

## ⚠️ Dépannage

### Problème: Frontend ne se connecte pas au backend
**Solution**: Vérifier que :
1. Le backend fonctionne sur le port 8001
2. CORS est configuré pour localhost:5173
3. L'URL d'API est correcte dans le frontend

### Problème: Erreur de base de données
**Solution**: 
```bash
cd backend
python setup_database.py
```

### Problème: Token expiré
**Solution**: Les tokens JWT expirent après 30 minutes. Se reconnecter.

## 🎯 Fonctionnalités à Tester

### Dashboard Admin
- [ ] Statistiques globales
- [ ] Gestion des utilisateurs
- [ ] Stock administrateur
- [ ] Pays et villes
- [ ] Analytics NFC
- [ ] Taux de commission

### Interface Utilisateur
- [ ] Connexion/Déconnexion
- [ ] Solde du portefeuille
- [ ] Historique des transactions
- [ ] Demande de prêt SOS
- [ ] Transferts entre comptes
- [ ] Recharge CinetPay

### Fonctionnalités Avancées
- [ ] Calcul automatique des commissions
- [ ] Gestion des limites par type de compte
- [ ] Remboursement automatique des prêts
- [ ] Pénalités de retard
- [ ] Notifications

## 🚀 Prochaines Étapes

1. **Test complet** de l'intégration frontend-backend
2. **Optimisation** des performances
3. **Tests automatisés** (Jest, Cypress)
4. **Déploiement** en environnement de staging
5. **Migration PostgreSQL** pour la production
6. **Monitoring** et logs avancés

---

**🎉 TIM CASH - Système Complet Opérationnel**  
*Backend SQLAlchemy + Frontend React + Base de données complète*

**Date**: 21 septembre 2025  
**Status**: ✅ PRÊT POUR LES TESTS D'INTÉGRATION
