# TIM CASH - Super-App Financière Complète

TIM CASH est une **super-app financière** innovante spécialement conçue pour l'Afrique de l'Ouest, offrant des services financiers mobiles avancés avec support NFC, prêts automatiques, marketplace intégrée et intégration CinetPay.

## 🎉 **NOUVEAU : Base de Données Étendue**
- 📊 **35+ tables** organisées par domaine métier
- 🗄️ **SQLite étendue** - Simple et sans mot de passe
- 🚀 **Prête pour la production** avec toutes les fonctionnalités avancées

## 🚀 Features

### Core Functionality
- **Advanced Authentication** - JWT with refresh tokens, rate limiting, and secure logout
- **Multi-Currency Wallet Management** - Electronic wallets with reload, withdraw, and transfer capabilities
- **Complete Loan System** - Loan applications with automated admin stock management
- **CinetPay Integration** - Secure payment processing with automated callbacks
- **Admin Stock Account** - Full financial tracking with commission management
- **Transaction Processing** - Complete audit trail with advanced filtering and search
- **Administrative Dashboard** - Enhanced analytics, reports, and financial monitoring
- **Real-time Notifications** - In-app notifications and transaction alerts

### User Roles
- **Admin** - Full platform access, user management, system configuration
- **Manager** - User management, loan approvals, transaction monitoring
- **User** - Personal wallet management, loan applications, transaction history

### Technical Features
- **Responsive Design** - Mobile-first approach with Tailwind CSS
- **Real-time Dashboard** - Interactive charts and enhanced financial analytics
- **Secure API** - FastAPI with rate limiting, validation, and comprehensive logging

### 🆕 **Nouvelles Fonctionnalités Étendues**
- **🏪 Marketplace Intégrée** - Catalogue de produits et services (airtime, factures, assurances)
- **🎯 Marketing Intelligent** - Campagnes, fidélité, parrainage avec points et niveaux
- **🎧 Support Client** - Système de tickets et conversations client-agent
- **📊 Analytics Avancées** - Tracking comportemental et business intelligence
- **🔒 Sécurité Enterprise** - Détection de fraude, audit trail, conformité KYC
- **⚙️ Configuration Dynamique** - Feature flags, A/B testing, paramètres centralisés
- **Admin Stock Management** - Automated admin account with full transaction tracking
- **CinetPay Integration** - Payment gateway with callback handling and signature verification
- **Advanced Security** - Rate limiting, input validation, and audit trails
- **Comprehensive Logging** - Structured logging with Winston for monitoring and debugging

## 🛠️ Technology Stack

### Frontend
- **React 18** with TypeScript
- **Tailwind CSS** for styling
- **React Router** for navigation
- **React Hook Form** with Yup validation
- **Recharts** for data visualization
- **Lucide React** for icons

### Backend
- **FastAPI** with Python 3.11+
- **SQLAlchemy** with **MySQL** database
- **PyMySQL** driver for MySQL connectivity
- **Pydantic** for advanced data validation with custom validators
- **JWT** authentication with refresh token support
- **BCrypt** for secure password hashing
- **SlowAPI** for rate limiting protection
- **Requests** for CinetPay API integration
- **Redis** for caching and session management
- **CORS** middleware for secure cross-origin requests

## 📦 Installation & Setup

### Prerequisites
- Node.js 18+ and npm
- Python 3.11+
- **MySQL 8.0+** (Base de données principale)
- Redis (optionnel, pour le cache)

### 🚀 Démarrage Rapide

#### Option 1: Script Automatique (Recommandé)
```bash
# Démarrage complet du système
start_timcash.bat
```

#### Option 2: Démarrage Manuel

##### 1. Configuration MySQL
```bash
cd backend
python setup_mysql.py  # Configuration automatique de MySQL
```

##### 2. Migration des Données
```bash
python recreate_database.py  # Création des tables et données de test
```

##### 3. Démarrage des Services
```bash
# Backend (Terminal 1)
python -m uvicorn main:app --reload --port 8001

# Frontend (Terminal 2)
npm run dev
```

### Services Disponibles
- **Frontend**: http://localhost:5173
- **Backend API**: http://localhost:8001
- **Documentation API**: http://localhost:8001/docs
- **Base MySQL**: localhost:3306 (timcash_db)

### Docker Setup
```bash
# Build and run with Docker Compose (includes Redis)
docker-compose up --build

# Services included:
# - Frontend (React + TypeScript)
# - Backend (FastAPI + Python)
# - Redis (Caching and rate limiting)
```

## 🔐 Demo Credentials

### Admin Access
- Email: `admin@timcash.com`
- Password: Any password (demo mode)
- Features: Full admin dashboard, stock management, financial reports, user management, loan approvals, CinetPay monitoring

### Standard User
- Email: `user@timcash.com`
- Password: Any password (demo mode)
- Features: Advanced wallet management, loan applications, transfers, withdrawals, transaction history

## 📊 API Endpoints

### Authentication
```
POST /auth/login          # User login with refresh token
POST /auth/register       # User registration
POST /auth/refresh        # Refresh access token
POST /auth/logout         # Secure logout
GET  /auth/me            # Get current user info
```

### Wallet Management
```
GET  /wallet             # Get user wallet
POST /wallet/reload      # Reload wallet via CinetPay
POST /wallet/withdraw    # Withdraw funds with commission
POST /wallet/transfer    # Transfer between users
GET  /wallet/history     # Paginated transaction history
POST /wallet/transaction # Create new transaction
GET  /transactions       # Get user transactions
```

### Advanced Loan System
```
POST /wallet-loans/create        # Create loan with admin stock update
GET  /wallet-loans/user-loans    # Get user loans
GET  /wallet-loans/search        # Search loans with filters
GET  /wallet-loans/filter        # Filter loans by date
POST /wallet-paiements/callback  # CinetPay payment callback
```

### Admin Stock Management
```
GET  /wallet-admins              # Admin transactions with pagination
GET  /wallet-admins/{id}         # Admin transaction details
GET  /wallet-admins/search       # Search admin transactions
```

### Enhanced Admin Endpoints
```
GET  /admin/dashboard     # Enhanced dashboard stats
GET  /admin/stock        # Admin stock account details
GET  /admin/stats        # Detailed system statistics
GET  /admin/reports      # Financial reports
POST /admin/commission   # Configure commission rates
GET  /admin/users        # All users management
GET  /admin/loans        # All loans management
GET  /admin/transactions # All transactions management
GET  /wallet-payouts     # CinetPay payout management
```

## 🏗️ Project Structure

```
timcash/
├── src/
│   ├── components/         # Reusable React components
│   │   ├── Layout/        # Layout components (Header, Sidebar)
│   │   └── Dashboard/     # Dashboard-specific components
│   ├── pages/             # Page components
│   │   ├── Auth/          # Authentication pages
│   │   └── Dashboard/     # Dashboard pages
│   ├── contexts/          # React contexts (Auth, etc.)
│   ├── types/             # TypeScript type definitions
│   └── App.tsx            # Main application component
├── backend/
│   ├── main.py           # FastAPI application
│   ├── requirements.txt  # Python dependencies
│   └── Dockerfile       # Backend container config
├── docker-compose.yml    # Multi-service orchestration
└── README.md            # Project documentation
```

## 🔒 Security Features

- **Advanced JWT Authentication** - Access and refresh tokens with secure expiration
- **Password Hashing** - BCrypt with salt for secure password storage
- **Rate Limiting** - Protection against brute force and DDoS attacks
- **Role-Based Access Control** - Granular permissions with admin/manager/user roles
- **CORS Protection** - Strict cross-origin request configuration
- **Input Validation** - Comprehensive Pydantic validation with custom validators
- **CinetPay Security** - Signature verification for payment callbacks
- **Admin Stock Control** - Automated financial controls with audit trails
- **Structured Logging** - Complete audit trail for security monitoring

## 🆕 Latest Updates (v0.1.0)

### ✅ Implemented Features
- **🏦 Complete Admin Stock Account** - Automated loan disbursement tracking
- **💳 CinetPay Integration** - Full payment processing with callbacks
- **🔄 Advanced Authentication** - Refresh tokens and secure logout
- **💰 Enhanced Wallet Operations** - Reload, withdraw, transfer with commissions
- **📊 Comprehensive Reporting** - Financial analytics and admin dashboards
- **🔒 Advanced Security** - Rate limiting and input validation
- **📝 Complete Documentation** - Technical guides and API examples

### 🚀 Future Enhancements

#### Planned Features
- **MySQL Database Integration** - Production database setup
- **Mobile Application** - React Native companion app
- **Advanced Analytics** - Machine learning insights and fraud detection
- **Multi-language Support** - Internationalization (French, English)
- **Cryptocurrency Support** - Digital currency wallets
- **Push Notifications** - Real-time alerts and notifications

#### Technical Improvements
- **WebSocket Support** - Real-time notifications and updates
- **Microservices Architecture** - Scalable service design
- **Kubernetes Deployment** - Container orchestration
- **Advanced Monitoring** - Prometheus and Grafana integration
- **Automated Testing** - Comprehensive test suite

## 📈 Performance & Scalability

- **Optimized Bundle** - Code splitting and lazy loading
- **Responsive Design** - Mobile-first approach
- **Efficient State Management** - Context API and local state
- **API Caching** - Strategic caching for performance
- **Docker Ready** - Containerized deployment

## 🤝 Contributing

1. Fork the repository
2. Create a feature branch (`git checkout -b feature/AmazingFeature`)
3. Commit your changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

## 📄 License

This project is proprietary - All rights reserved.

## 📚 Documentation

- **[Technical Documentation](MISE_A_JOUR_COMPTE_STOCK_ADMIN.md)** - Complete implementation guide
- **[Testing Guide](LOAN_ADMIN_STOCK_TEST.md)** - Validation and testing procedures
- **[API Examples](API_USAGE_EXAMPLES.md)** - Practical usage examples
- **[API Documentation](http://localhost:8000/docs)** - Interactive Swagger documentation

## 📞 Support

For support and questions, please contact the development team or create an issue in the project repository.

### Configuration Required

Before production deployment, configure these environment variables:
```bash
SECRET_KEY=your-production-secret-key
CINETPAY_API_KEY=your-cinetpay-api-key
CINETPAY_SITE_ID=your-cinetpay-site-id
CINETPAY_SECRET_KEY=your-cinetpay-secret-key
REDIS_URL=redis://localhost:6379/0
```

---

**TimCash v0.1.0** - Modern Financial Platform  
*Built with ❤️ using React, TypeScript, FastAPI, and CinetPay*  
*September 2024 - Production Ready*