# 🔄 Migration TIM CASH vers MySQL

Ce guide vous accompagne dans la migration de TIM CASH de SQLite vers MySQL.

## 📋 Prérequis

### 1. Installation de MySQL
```bash
# Windows (avec Chocolatey)
choco install mysql

# Ou télécharger depuis: https://dev.mysql.com/downloads/mysql/
```

### 2. Démarrage du service MySQL
```bash
# Windows
net start mysql

# Ou via les services Windows
services.msc -> MySQL -> Démarrer
```

### 3. Vérification de l'installation
```bash
mysql --version
mysql -u root -p
```

## 🚀 Étapes de Migration

### Étape 1: Installation des dépendances Python
```bash
cd c:\frontnew\backend
pip install -r requirements.txt
```

### Étape 2: Configuration de MySQL
```bash
# Exécuter le script de configuration
python setup_mysql.py
```

Ce script va :
- ✅ Créer la base de données `timcash_db`
- ✅ Créer l'utilisateur `timcash` avec le mot de passe `timcash123`
- ✅ Accorder tous les privilèges nécessaires
- ✅ Tester la connexion

### Étape 3: Configuration de l'environnement
```bash
# Copier le fichier de configuration MySQL
copy .env.mysql .env

# Ou créer manuellement le fichier .env avec:
DATABASE_URL=mysql+pymysql://timcash:timcash123@localhost/timcash_db
```

### Étape 4: Migration des données
```bash
# Recréer la base de données avec les données de test
python recreate_database.py
```

### Étape 5: Démarrage du serveur
```bash
# Démarrer le serveur FastAPI
python -m uvicorn main:app --reload --port 8001
```

## 🔧 Configuration Personnalisée

### Modifier les paramètres MySQL
Éditez le fichier `.env` pour personnaliser :

```env
# Base de données
DATABASE_URL=mysql+pymysql://votre_user:votre_password@localhost/votre_db

# Configuration MySQL détaillée
MYSQL_HOST=localhost
MYSQL_PORT=3306
MYSQL_USER=votre_user
MYSQL_PASSWORD=votre_password
MYSQL_DATABASE=votre_db
```

### Configuration avancée MySQL
Dans `database.py`, vous pouvez ajuster :

```python
mysql_config = {
    "pool_size": 10,        # Nombre de connexions dans le pool
    "max_overflow": 20,     # Connexions supplémentaires autorisées
    "pool_pre_ping": True,  # Vérifier les connexions avant utilisation
    "pool_recycle": 3600,   # Recycler les connexions après 1h
    "echo": False           # Afficher les requêtes SQL (debug)
}
```

## 🧪 Tests de Vérification

### 1. Test de connexion
```bash
# Tester la connexion à la base
python -c "from database import engine; print('✅ Connexion MySQL OK' if engine.connect() else '❌ Erreur')"
```

### 2. Test des données
```bash
# Vérifier les données créées
python -c "
from database import SessionLocal
from models import User, Wallet
db = SessionLocal()
print(f'Utilisateurs: {db.query(User).count()}')
print(f'Portefeuilles: {db.query(Wallet).count()}')
db.close()
"
```

### 3. Test de l'API
```bash
# Démarrer le serveur et tester
curl http://localhost:8001/health
curl http://localhost:8001/admin/stats
```

## 📊 Avantages de MySQL vs SQLite

| Fonctionnalité | SQLite | MySQL |
|----------------|--------|-------|
| **Performance** | Bonne pour petites apps | Excellente pour production |
| **Concurrence** | Limitée | Excellente |
| **Scalabilité** | Limitée | Très bonne |
| **Sauvegardes** | Copie de fichier | Outils avancés |
| **Réplication** | Non | Oui |
| **Clustering** | Non | Oui |
| **Sécurité** | Basique | Avancée |

## 🔒 Sécurité MySQL

### 1. Sécurisation de l'installation
```sql
-- Connexion en tant que root
mysql -u root -p

-- Supprimer les utilisateurs anonymes
DELETE FROM mysql.user WHERE User='';

-- Supprimer la base de test
DROP DATABASE IF EXISTS test;

-- Recharger les privilèges
FLUSH PRIVILEGES;
```

### 2. Création d'un utilisateur sécurisé
```sql
-- Créer un utilisateur avec des privilèges limités
CREATE USER 'timcash_prod'@'localhost' IDENTIFIED BY 'mot_de_passe_fort';
GRANT SELECT, INSERT, UPDATE, DELETE ON timcash_db.* TO 'timcash_prod'@'localhost';
FLUSH PRIVILEGES;
```

## 🚨 Dépannage

### Erreur de connexion MySQL
```bash
# Vérifier le service
net start mysql

# Vérifier les logs
# Windows: C:\ProgramData\MySQL\MySQL Server 8.0\Data\*.err
```

### Erreur d'authentification
```sql
-- Réinitialiser le mot de passe utilisateur
ALTER USER 'timcash'@'localhost' IDENTIFIED BY 'nouveau_password';
FLUSH PRIVILEGES;
```

### Erreur de permissions
```sql
-- Accorder tous les privilèges
GRANT ALL PRIVILEGES ON timcash_db.* TO 'timcash'@'localhost';
FLUSH PRIVILEGES;
```

### Problème de charset
```sql
-- Vérifier le charset de la base
SHOW CREATE DATABASE timcash_db;

-- Modifier si nécessaire
ALTER DATABASE timcash_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

## 📈 Monitoring et Maintenance

### 1. Surveillance des performances
```sql
-- Voir les processus actifs
SHOW PROCESSLIST;

-- Statistiques des tables
SELECT 
    table_name,
    table_rows,
    data_length,
    index_length
FROM information_schema.tables 
WHERE table_schema = 'timcash_db';
```

### 2. Sauvegarde automatique
```bash
# Script de sauvegarde quotidienne
mysqldump -u timcash -p timcash_db > backup_$(date +%Y%m%d).sql
```

### 3. Optimisation
```sql
-- Analyser les tables
ANALYZE TABLE users, wallets, transactions;

-- Optimiser les tables
OPTIMIZE TABLE users, wallets, transactions;
```

## 🎉 Migration Terminée !

Votre système TIM CASH utilise maintenant MySQL comme base de données principale.

### Prochaines étapes recommandées :
1. ✅ Configurer les sauvegardes automatiques
2. ✅ Mettre en place le monitoring
3. ✅ Optimiser les index selon l'usage
4. ✅ Configurer la réplication (si nécessaire)
5. ✅ Sécuriser l'accès en production

### Services actifs :
- 🗄️ **MySQL** : `localhost:3306`
- 🚀 **Backend API** : `http://localhost:8001`
- 🌐 **Frontend** : `http://localhost:5173`
- 📚 **Documentation API** : `http://localhost:8001/docs`

**Félicitations ! Votre migration MySQL est terminée ! 🎉**
