# 🔄 FLUX CORRECT DES COMMISSIONS CINETPAY

## 📅 Date de correction
**Date:** 2025-11-09

---

## ✅ CLARIFICATION IMPORTANTE

### **Commission CinetPay**

CinetPay déduit **TOUJOURS** sa commission, que ce soit pour :
- ✅ **Recharge** (Dépôt Mobile Money → Wallet TIM CASH)
- ✅ **Retrait** (Wallet TIM CASH → Mobile Money)

### **Pourcentage Variable**

La commission CinetPay **N'EST PAS FIXE à 1%**. Elle varie selon l'opérateur Mobile Money :
- **Wave** : X%
- **Orange Money** : Y%
- **Moov Money** : Z%
- **MTN Mobile Money** : W%

**Tout est géré automatiquement par l'API CinetPay.**

---

## 💰 FLUX DE RECHARGE (OPTION A - IMPLÉMENTÉE)

### **Principe:**
Le client paie la commission TIM CASH en plus du montant souhaité.

### **Étapes détaillées:**

```
┌─────────────────────────────────────────────────────────────┐
│  1. CLIENT DEMANDE RECHARGE: 10 000 FCFA                    │
└─────────────────────────────────────────────────────────────┘
                          ↓
┌─────────────────────────────────────────────────────────────┐
│  2. TIM CASH CALCULE                                        │
│     • Montant demandé: 10 000 FCFA                          │
│     • Commission TIM CASH (2%): +200 FCFA                   │
│     • Total à payer: 10 200 FCFA                            │
└─────────────────────────────────────────────────────────────┘
                          ↓
┌─────────────────────────────────────────────────────────────┐
│  3. CRÉATION TRANSACTION                                    │
│     • Type: RECHARGE_CINETPAY                               │
│     • Amount: 10 000 FCFA (montant attendu)                 │
│     • Commission: 200 FCFA (TIM CASH)                       │
│     • Status: PENDING                                       │
└─────────────────────────────────────────────────────────────┘
                          ↓
┌─────────────────────────────────────────────────────────────┐
│  4. GÉNÉRATION LIEN PAIEMENT CINETPAY                       │
│     • Montant envoyé à CinetPay: 10 200 FCFA                │
│     • Client redirigé vers page paiement                    │
└─────────────────────────────────────────────────────────────┘
                          ↓
┌─────────────────────────────────────────────────────────────┐
│  5. CLIENT PAIE VIA MOBILE MONEY                            │
│     • Montant payé: 10 200 FCFA                             │
│     • Opérateur: Wave/Orange/Moov/MTN                       │
└─────────────────────────────────────────────────────────────┘
                          ↓
┌─────────────────────────────────────────────────────────────┐
│  6. CINETPAY TRAITE LE PAIEMENT                             │
│     • Reçoit: 10 200 FCFA                                   │
│     • Déduit SA commission (variable selon opérateur)       │
│       Exemple Wave: -102 FCFA (1%)                          │
│     • Montant net: 10 098 FCFA                              │
└─────────────────────────────────────────────────────────────┘
                          ↓
┌─────────────────────────────────────────────────────────────┐
│  7. CALLBACK CINETPAY VERS TIM CASH                         │
│     • Status: ACCEPTED                                      │
│     • Amount: 10 098 FCFA ← MONTANT RÉEL REÇU               │
│     • Reference: RELOAD-xxxxx                               │
│     • Operator_id: WAVE (optionnel)                         │
└─────────────────────────────────────────────────────────────┘
                          ↓
┌─────────────────────────────────────────────────────────────┐
│  8. TRAITEMENT BACKEND TIM CASH                             │
│     • Montant réel reçu: 10 098 FCFA                        │
│     • Commission CinetPay déduite: 102 FCFA                 │
└─────────────────────────────────────────────────────────────┘
                          ↓
┌─────────────────────────────────────────────────────────────┐
│  9. VÉRIFICATION PRÊT ACTIF                                 │
│     • Prêt trouvé: 5 000 FCFA + 6% = 5 300 FCFA dû          │
│     • Montant disponible: 10 098 FCFA                       │
│     • Remboursement: -5 300 FCFA                            │
│     • Reste: 4 798 FCFA                                     │
└─────────────────────────────────────────────────────────────┘
                          ↓
┌─────────────────────────────────────────────────────────────┐
│  10. CRÉDIT WALLET                                          │
│      • Wallet crédité: 4 798 FCFA                           │
│      • Prêt marqué: COMPLETED                               │
│      • Compte débloqué: ✅                                   │
└─────────────────────────────────────────────────────────────┘
                          ↓
┌─────────────────────────────────────────────────────────────┐
│  11. MISE À JOUR STOCK ADMIN                                │
│      • Commission TIM CASH: +200 FCFA                       │
│      • Remboursement prêt: +5 300 FCFA                      │
│      • Total: +5 500 FCFA                                   │
└─────────────────────────────────────────────────────────────┘
```

---

## 📊 TABLEAU RÉCAPITULATIF

| Acteur | Montant Reçu | Montant Déduit | Gain Net |
|--------|--------------|----------------|----------|
| **Client** | 4 798 FCFA (wallet) | 10 200 FCFA (payé) | -5 402 FCFA |
| **TIM CASH** | 10 098 FCFA (de CinetPay) | 4 798 FCFA (crédité client) | +200 FCFA (commission) + 5 300 FCFA (prêt remboursé) |
| **CinetPay** | 10 200 FCFA (du client) | 10 098 FCFA (à TIM CASH) | +102 FCFA (commission) |
| **Prêteur (Admin)** | 5 300 FCFA (remboursement) | 5 000 FCFA (prêté) | +300 FCFA (intérêt 6%) |

---

## 🔧 MODIFICATIONS APPORTÉES

### **1. Modèle CinetPayCallbackRequest (main.py)**

```python
class CinetPayCallbackRequest(BaseModel):
    """
    Callback simplifié pour tests
    Pour production, utiliser CinetPayCallback de schemas/transaction.py
    """
    transaction_id: str
    status: str
    amount: float  # ✅ Montant APRÈS déduction commission CinetPay
    reference: str
    signature: str
    operator_id: Optional[str] = None  # ✅ ID de l'opérateur (Wave, Orange, etc.)
```

### **2. Callback Handler (main.py, lignes 2724-2783)**

```python
if callback_data.status == "ACCEPTED":
    # ✅ IMPORTANT: callback_data.amount contient le montant APRÈS déduction commission CinetPay
    actual_amount_received = callback_data.amount
    
    print(f"💰 Callback CinetPay reçu:")
    print(f"   • Montant transaction initiale: {transaction.amount} FCFA")
    print(f"   • Montant réel reçu (après commission CinetPay): {actual_amount_received} FCFA")
    print(f"   • Commission CinetPay déduite: {transaction.amount - actual_amount_received} FCFA")
    if callback_data.operator_id:
        print(f"   • Opérateur: {callback_data.operator_id}")
    
    # ✅ Utiliser le montant RÉEL pour le remboursement automatique
    repayment_result = LoanAutoRepaymentService.process_auto_repayment(
        user_id=user.id,
        recharge_amount=actual_amount_received,  # ✅ Montant réel après commission CinetPay
        db=db
    )
```

### **3. Documentation (SYSTEME_COMMISSIONS_ET_REMBOURSEMENT_PRETS.md)**

Mise à jour pour clarifier :
- Commission CinetPay variable selon opérateur
- Montant réel reçu dans le callback
- Flux correct avec déduction CinetPay

---

## ✅ RÉSUMÉ

### **Ce qui est correct:**

1. ✅ Client paie la commission TIM CASH (Option A)
2. ✅ CinetPay déduit SA commission automatiquement
3. ✅ Commission CinetPay variable selon opérateur (Wave, Orange, Moov, MTN)
4. ✅ Callback contient le montant RÉEL après déduction CinetPay
5. ✅ Remboursement automatique utilise le montant réel
6. ✅ Wallet crédité avec le montant réel après remboursement prêt

### **Exemple complet:**

```
Client veut: 10 000 FCFA
Client paie: 10 200 FCFA (+ 2% TIM CASH)
CinetPay déduit: -102 FCFA (variable selon opérateur)
TIM CASH reçoit: 10 098 FCFA
Prêt à rembourser: -5 300 FCFA
Wallet final: 4 798 FCFA
```

---

## 🚀 PROCHAINES ÉTAPES

1. ✅ **Code corrigé** - Utilise `callback_data.amount` (montant réel)
2. ✅ **Documentation mise à jour** - Flux correct documenté
3. ⏳ **Tests en production** - Vérifier avec vrais paiements CinetPay
4. ⏳ **Monitoring** - Logger les commissions CinetPay réelles par opérateur

---

## 📝 NOTES IMPORTANTES

- **CinetPay gère tout** : Les commissions variables selon opérateur sont gérées automatiquement par leur API
- **Pas de calcul côté TIM CASH** : On ne calcule PAS la commission CinetPay, on utilise le montant réel du callback
- **Transparence** : Le client voit le montant total à payer (avec commission TIM CASH)
- **Flexibilité** : Le système s'adapte automatiquement aux différents opérateurs


