# TIM CASH - Gestion des Pays/Villes et Publicités

## 🌍 **Système de Gestion des Pays et Villes**

### **Objectif**
Permettre l'expansion internationale de TIM CASH avec la gestion des branches par pays et villes, facilitant la création de nouveaux marchés.

### **Fonctionnalités Principales**

#### **1. Gestion des Pays**
- ✅ **Création de nouveaux pays** : Ajout de pays pour l'expansion TIM CASH
- ✅ **Informations complètes** : Nom, code ISO, devise, symbole monétaire, drapeau
- ✅ **Statut actif/inactif** : Contrôle de l'activation des services par pays
- ✅ **Métriques temps réel** : Nombre d'utilisateurs, volume des transactions
- ✅ **Gestion des devises** : Support multi-devises (FCFA, EUR, USD, etc.)

#### **2. Gestion des Villes**
- ✅ **Branches par ville** : Création de branches TIM CASH dans chaque ville
- ✅ **Codes de branche** : Système de codification unique (ex: TIM-CI-ABJ)
- ✅ **Métriques locales** : Utilisateurs et volume par ville
- ✅ **Statut indépendant** : Activation/désactivation par ville
- ✅ **Traçabilité** : Historique de création et modifications

### **Interface Utilisateur**

#### **Vue Pays**
```typescript
interface Country {
  id: string;
  name: string;
  code: string; // Code ISO (CI, SN, ML, etc.)
  currency: string; // FCFA, EUR, USD
  currencySymbol: string;
  flag: string; // Emoji du drapeau
  isActive: boolean;
  totalUsers: number;
  totalVolume: number;
  cities: City[];
  createdAt: string;
}
```

#### **Vue Villes**
```typescript
interface City {
  id: string;
  name: string;
  countryId: string;
  isActive: boolean;
  branchCode: string; // TIM-{COUNTRY}-{CITY}
  users: number;
  volume: number;
  createdAt: string;
}
```

### **Fonctionnalités Interface**

#### **Statistiques Globales**
- **Pays Total** : Nombre de pays où TIM CASH est disponible
- **Villes Total** : Nombre de branches actives
- **Utilisateurs Total** : Somme de tous les utilisateurs
- **Volume Total** : Volume financier global en FCFA

#### **Filtres et Recherche**
- ✅ **Recherche** : Par nom de pays/ville ou code de branche
- ✅ **Filtres** : Tous, Actifs, Inactifs
- ✅ **Basculement de vue** : Pays ↔ Villes
- ✅ **Actions** : Créer, Modifier, Supprimer

#### **Modals Interactifs**
- **Nouveau Pays** : Formulaire complet avec validation
- **Nouvelle Ville** : Ajout de ville avec génération automatique du code branche
- **Validation** : Codes ISO, devises supportées, noms uniques

### **Endpoints Backend**

#### **API Pays**
```python
GET /countries
# Récupère tous les pays avec leurs villes

POST /countries
# Crée un nouveau pays
{
  "name": "Burkina Faso",
  "code": "BF",
  "currency": "FCFA",
  "currencySymbol": "FCFA"
}

POST /countries/{country_id}/cities
# Ajoute une ville à un pays
{
  "name": "Ouagadougou",
  "branchCode": "TIM-BF-OUA"
}
```

---

## 📱 **Système de Gestion des Publicités**

### **Objectif**
Créer et gérer les campagnes publicitaires pour l'application mobile TIM CASH avec adaptation automatique aux différentes tailles d'écran.

### **Types de Publicités**

#### **1. Bannière (Banner)**
- **Format** : Image horizontale
- **Placement** : Haut/bas de l'écran mobile
- **Taille** : Adaptation automatique
- **Durée** : Affichage permanent

#### **2. Pop-up**
- **Format** : Modal centré
- **Placement** : Superposition sur l'interface
- **Interaction** : Clic pour fermer ou action
- **Timing** : Déclenchement programmé

#### **3. Vidéo**
- **Format** : MP4, durée limitée
- **Placement** : Plein écran ou intégré
- **Contrôles** : Lecture automatique ou manuelle
- **Qualité** : Adaptation à la bande passante

#### **4. Native**
- **Format** : Intégré au contenu
- **Placement** : Dans les listes de transactions
- **Style** : Cohérent avec l'interface TIM CASH
- **Discrétion** : Publicité non intrusive

### **Fonctionnalités Principales**

#### **1. Création de Campagnes**
```typescript
interface Advertisement {
  id: string;
  title: string;
  description: string;
  imageUrl: string;
  type: 'banner' | 'popup' | 'video' | 'native';
  status: 'active' | 'paused' | 'scheduled' | 'expired';
  targetCountries: string[];
  targetCities: string[];
  startDate: string;
  endDate: string;
  budget: number;
  spent: number;
  impressions: number;
  clicks: number;
  ctr: number; // Click-through rate
}
```

#### **2. Ciblage Géographique**
- ✅ **Par pays** : Ciblage au niveau national
- ✅ **Par ville** : Ciblage local précis
- ✅ **Multi-sélection** : Plusieurs pays/villes simultanément
- ✅ **Exclusions** : Zones à exclure de la campagne

#### **3. Gestion du Budget**
- ✅ **Budget total** : Montant maximum en FCFA
- ✅ **Dépenses en temps réel** : Suivi des coûts
- ✅ **Barre de progression** : Visualisation du budget utilisé
- ✅ **Alertes** : Notifications quand budget atteint

#### **4. Métriques et Performance**
- ✅ **Impressions** : Nombre d'affichages
- ✅ **Clics** : Interactions utilisateur
- ✅ **CTR** : Taux de clic (clicks/impressions × 100)
- ✅ **Coût par clic** : Budget/clics
- ✅ **ROI** : Retour sur investissement

### **Interface de Gestion**

#### **Dashboard Publicités**
- **Statistiques globales** : Total publicités, budget, impressions, CTR moyen
- **Filtres avancés** : Par statut, type, période
- **Recherche** : Par titre, description, ID
- **Actions en lot** : Pause/reprise multiple

#### **Création de Publicité**
- **Upload de fichiers** : Images, vidéos (drag & drop)
- **Aperçu en temps réel** : Prévisualisation mobile
- **Validation** : Formats supportés, tailles optimales
- **Programmation** : Dates de début/fin automatiques

#### **Gestion des Campagnes**
- ✅ **Pause/Reprise** : Contrôle instantané
- ✅ **Modification** : Édition des paramètres
- ✅ **Duplication** : Copie de campagnes existantes
- ✅ **Archivage** : Historique des campagnes

### **Adaptation Mobile Automatique**

#### **Responsive Design**
```css
/* Bannière mobile */
.banner-ad {
  width: 100%;
  max-width: 400px;
  height: auto;
  aspect-ratio: 16/9;
}

/* Pop-up adaptatif */
.popup-ad {
  width: 90vw;
  max-width: 350px;
  height: auto;
  border-radius: 12px;
}

/* Vidéo responsive */
.video-ad {
  width: 100%;
  height: 56.25vw; /* 16:9 ratio */
  max-height: 200px;
}
```

#### **Optimisation Performance**
- ✅ **Compression automatique** : Images optimisées
- ✅ **Lazy loading** : Chargement à la demande
- ✅ **Cache intelligent** : Stockage local temporaire
- ✅ **Fallback** : Images de remplacement si échec

### **Endpoints Backend**

#### **API Publicités**
```python
GET /advertisements
# Récupère toutes les publicités avec métriques

POST /advertisements
# Crée une nouvelle publicité
{
  "title": "Promo TIM BUSINESS",
  "description": "Ouvrez votre compte professionnel",
  "type": "banner",
  "targetCountries": ["Côte d'Ivoire"],
  "budget": 1000000
}

PUT /advertisements/{ad_id}/status
# Met à jour le statut (active, paused, etc.)

DELETE /advertisements/{ad_id}
# Supprime une publicité
```

---

## 🚀 **Intégration Système**

### **Navigation**
- **Route Pays** : `/countries` (Administration → Pays et Villes)
- **Route Publicités** : `/advertising` (Administration → Publicités)
- **Accès** : Administrateurs uniquement
- **Icônes** : Globe (pays), Image (publicités)

### **Sécurité**
- ✅ **Authentification** : JWT requis
- ✅ **Autorisation** : Rôle admin obligatoire
- ✅ **Validation** : Données d'entrée vérifiées
- ✅ **Audit** : Traçabilité des actions

### **Performance**
- ✅ **Pagination** : Gestion des grandes listes
- ✅ **Cache** : Données fréquemment utilisées
- ✅ **Optimisation** : Requêtes efficaces
- ✅ **Monitoring** : Métriques de performance

---

## 📊 **Cas d'Usage**

### **Expansion Géographique**
1. **Nouveau Marché** : Ajouter le Mali comme nouveau pays
2. **Nouvelle Ville** : Ouvrir une branche à Bouaké
3. **Activation Progressive** : Tester dans une ville avant le pays entier
4. **Métriques** : Suivre l'adoption par région

### **Campagnes Marketing**
1. **Lancement Produit** : Publicité pour TIM BUSINESS
2. **Promotion Locale** : Offre spéciale pour Abidjan
3. **Saisonnalité** : Campagne de fin d'année
4. **A/B Testing** : Comparer différents formats

### **Monétisation**
1. **Publicités Partenaires** : Revenus publicitaires
2. **Promotions Internes** : Encourager l'usage des services
3. **Ciblage Précis** : Maximiser le ROI
4. **Analytics** : Optimiser les performances

---

## 🎯 **Prochaines Étapes**

### **Améliorations Prévues**
- [ ] **Upload de fichiers** : Intégration stockage cloud
- [ ] **Analytics avancées** : Graphiques détaillés
- [ ] **Ciblage démographique** : Age, profession, revenus
- [ ] **API mobile** : Endpoints pour l'app mobile
- [ ] **Notifications push** : Intégration avec les publicités
- [ ] **Géolocalisation** : Ciblage GPS précis

### **Optimisations**
- [ ] **Performance** : Cache Redis pour les publicités
- [ ] **Scalabilité** : Base de données dédiée
- [ ] **Monitoring** : Métriques temps réel
- [ ] **Sécurité** : Chiffrement des données sensibles

---

## ✅ **Résultat**

Le système de gestion des pays/villes et publicités est maintenant **complètement opérationnel** avec :

- ✅ **Interface admin complète** pour la gestion
- ✅ **Backend fonctionnel** avec API REST
- ✅ **Navigation intégrée** dans la sidebar
- ✅ **Données réalistes** pour la démonstration
- ✅ **Responsive design** pour tous les écrans
- ✅ **Sécurité** et validation appropriées

TIM CASH peut maintenant **s'étendre internationalement** et **monétiser via la publicité** ! 🎉
