# Endpoints API Backend Requis pour TIM CASH

## Base URL
```
http://localhost:8001
```

## Authentication
Toutes les requêtes nécessitent un token JWT dans le header:
```
Authorization: Bearer <token>
```

---

## 1. DASHBOARD

### GET /admin/dashboard/stats
Récupère les statistiques du dashboard
```json
Response:
{
  "users": {
    "total": 0,
    "tim_mini": 0,
    "tim_maxi": 0,
    "tim_business": 0
  },
  "transactions": {
    "total": 0,
    "nfc": 0,
    "volume": 0
  },
  "loans": {
    "active": 0,
    "pending": 0,
    "total_amount": 0
  },
  "recharges": {
    "total": 0,
    "volume": 0
  },
  "admin_stock": {
    "balance": 0
  }
}
```

---

## 2. USERS

### GET /admin/users
Liste tous les utilisateurs
```json
Response:
{
  "users": [
    {
      "id": "string",
      "full_name": "string",
      "email": "string",
      "phone": "string",
      "tim_account_type": "TIM_MINI|TIM_MAXI|TIM_BUSINESS",
      "wallet_balance": 0,
      "is_active": true,
      "created_at": "2024-01-01T00:00:00Z",
      "last_login": "2024-01-01T00:00:00Z"
    }
  ]
}
```

### GET /admin/users/{user_id}
Détails d'un utilisateur

### PUT /admin/users/{user_id}
Mettre à jour un utilisateur

---

## 3. WALLETS

### GET /admin/wallets
Liste tous les portefeuilles
```json
Response:
{
  "wallets": [
    {
      "id": "string",
      "user_id": "string",
      "user_name": "string",
      "tim_type": "TIM_MINI|TIM_MAXI|TIM_BUSINESS",
      "balance": 0,
      "status": "active|blocked|suspended",
      "created_at": "2024-01-01T00:00:00Z"
    }
  ]
}
```

### GET /admin/wallets/{wallet_id}
Détails d'un portefeuille

### GET /admin/wallets/{wallet_id}/transactions
Transactions d'un portefeuille

---

## 4. TRANSACTIONS

### GET /admin/transactions
Liste toutes les transactions
Query params: `type`, `status`, `startDate`, `endDate`, `limit`

```json
Response:
{
  "transactions": [
    {
      "id": "string",
      "wallet_id": "string",
      "type": "credit|debit|transfer|nfc|loan|repayment",
      "amount": 0,
      "currency": "FCFA",
      "description": "string",
      "status": "pending|completed|failed",
      "created_at": "2024-01-01T00:00:00Z"
    }
  ]
}
```

### GET /admin/transactions/{transaction_id}
Détails d'une transaction

---

## 5. RECHARGES

### GET /admin/recharges
Liste toutes les recharges CinetPay
Query params: `status`, `startDate`, `endDate`

```json
Response:
{
  "recharges": [
    {
      "id": "string",
      "user_id": "string",
      "user_name": "string",
      "amount": 0,
      "commission": 0,
      "status": "pending|completed|failed",
      "cinetpay_transaction_id": "string",
      "payment_method": "mobile_money|card|bank",
      "created_at": "2024-01-01T00:00:00Z"
    }
  ]
}
```

### GET /admin/recharges/{recharge_id}
Détails d'une recharge

---

## 6. LOANS (PRÊTS)

### GET /admin/loans
Liste tous les prêts
Query params: `status`, `type`

```json
Response:
{
  "loans": [
    {
      "id": "string",
      "user_id": "string",
      "user_name": "string",
      "amount": 0,
      "interest_rate": 6,
      "penalty_rate": 15,
      "status": "pending|active|completed|rejected",
      "due_date": "2024-01-01T00:00:00Z",
      "created_at": "2024-01-01T00:00:00Z"
    }
  ]
}
```

### GET /admin/loans/{loan_id}
Détails d'un prêt

### POST /admin/loans/{loan_id}/approve
Approuver un prêt
```json
Body:
{
  "approved_amount": 0,
  "notes": "string"
}
```

### POST /admin/loans/{loan_id}/reject
Rejeter un prêt
```json
Body:
{
  "reason": "string"
}
```

### GET /admin/loans/repayments
Liste des remboursements de prêts

---

## 7. ADMIN STOCK

### GET /admin/stock
Récupère le solde du compte stock admin
```json
Response:
{
  "balance": 0,
  "last_updated": "2024-01-01T00:00:00Z"
}
```

### PUT /admin/stock
Mettre à jour le stock admin
```json
Body:
{
  "amount": 0,
  "type": "add|withdraw",
  "description": "string"
}
```

---

## 8. COMMISSIONS

### GET /admin/commissions
Liste toutes les commissions configurées
```json
Response:
{
  "commissions": [
    {
      "id": "string",
      "name": "string",
      "type": "percentage|fixed",
      "value": 0,
      "category": "recharge_cinetpay|nfc_transaction|loan_interest",
      "is_active": true
    }
  ]
}
```

### PUT /admin/commissions/{commission_id}
Mettre à jour une commission

---

## 9. NOTIFICATIONS

### GET /admin/notifications
Liste toutes les notifications
```json
Response:
{
  "notifications": [
    {
      "id": "string",
      "type": "info|warning|error|success",
      "title": "string",
      "message": "string",
      "read": false,
      "created_at": "2024-01-01T00:00:00Z"
    }
  ]
}
```

### POST /admin/notifications/{notification_id}/read
Marquer une notification comme lue

---

## 10. ANALYTICS

### GET /admin/analytics
Récupère les analytics générales
Query params: `startDate`, `endDate`, `type`

```json
Response:
{
  "revenue": 0,
  "users": 0,
  "transactions": 0,
  "loans": 0,
  "chart_data": [
    {
      "month": "Jan",
      "revenue": 0,
      "users": 0,
      "transactions": 0
    }
  ]
}
```

### GET /admin/analytics/nfc
Analytics spécifiques NFC

---

## 11. REPORTS

### POST /admin/reports/generate
Générer un rapport
```json
Body:
{
  "type": "financial|transactions|users|loans",
  "startDate": "2024-01-01",
  "endDate": "2024-12-31",
  "format": "pdf|excel|csv"
}

Response:
{
  "report_id": "string",
  "download_url": "string"
}
```

### GET /admin/reports
Liste des rapports générés

---

## Notes d'implémentation

1. **Tous les endpoints doivent être protégés** par authentification JWT
2. **Les montants** sont en FCFA (entiers)
3. **Les dates** sont au format ISO 8601
4. **La pagination** peut être ajoutée avec `?page=1&limit=50`
5. **Les erreurs** doivent retourner un format standard:
```json
{
  "error": "Message d'erreur",
  "code": "ERROR_CODE",
  "details": {}
}
```
