from datetime import date, datetime
from enum import Enum
from typing import Optional
from models import PaymentMethod,TransactionStatus
from pydantic import BaseModel, Field

class WalletTransferRequest(BaseModel):
    recipient_phone: str = Field(..., description="Numéro du destinataire")
    amount: float = Field(..., gt=0, description="Montant à transférer")
    description: Optional[str] = Field("Transfert d'argent", max_length=255)
    transfer_type: str = Field(default="wallet_to_mobile", description="Type de transfert")
    
class PaymentStatus(str, Enum):
    PENDING = "pending"
    COMPLETED = "completed"
    FAILED = "failed"
    
class TransactionType(str,Enum):
    NFC_DEPOSIT = "nfc_deposit"
    NFC_WITHDRAWAL = "nfc_withdrawal"
    RECHARGE_CINETPAY = "recharge_cinetpay"
    RECHARGE_BY_BUSINESS = "recharge_by_business"
    PRET_MOBILE = "pret_mobile"
    COMMISSION = "commission"
    REMBOURSEMENT_AUTO = "remboursement_auto"
    VIREMENT_BANCAIRE = "virement_bancaire"
    MOBILE_TRANSFER = "mobile_transfer"
    PRELEVEMENT = "prelevement"
    DEPOT = "depot"
    RECHARGEMENT = "rechargement"
    RETRAIT = "retrait"
    TRANSFERT = "transfert"
    PAIEMENT = "paiement"


class TransferUser(BaseModel):
    full_name: str
    id: str
    phone: str



class ValidateTransaction(BaseModel):
    transaction_id: str
    validation_method: Optional[str] = None
    notes: Optional[str] = None
    external_reference: Optional[str] = None


class TransferInitResponse(BaseModel):
    id: str
    amount: float
    status: str
    transaction_type: TransactionType
    created_at: datetime
    user: TransferUser

    class Config:
        from_attributes = True
    

class CinetPayCallback(BaseModel):
    cpm_trans_id: str
    cpm_site_id: str
    cpm_amount: str
    cpm_currency: str
    cpm_payid: str
    cpm_payment_config: str
    cpm_language: str
    cpm_version: str
    cpm_payment_method: str
    cpm_trans_status: str
    cpm_designateid: str
    signature: Optional[str] = None
    cpm_phone_prefixe: Optional[str] = None
    cel_phone_num: Optional[str] = None
    cpm_ipn_ack: Optional[str] = None
    created_at: Optional[str] = None
    updated_at: Optional[str] = None
    cpm_result: Optional[str] = None
    cpm_trans_date: Optional[str] = None
    cpm_error_message: Optional[str] = None

class UserOut(BaseModel):
    id: str
    full_name: str
    email: str
    phone: str
    tim_account_type: str
    created_at: Optional[datetime]
    updated_at: Optional[datetime]

    class Config:
        orm_mode = True

# Modèle pour la recharge
class WalletReloadRequest(BaseModel):
    amount: float = Field(..., gt=0, description="Montant à recharger")



class WalletTransactionRequest(BaseModel):
    phone: str
    amount: float 
    
class TransactionOut(BaseModel):
    id: str
    user_id: str
    amount: float
    commission_amount: float
    commission_rate: float
    description: Optional[str]
    reference: Optional[str]
    external_reference: Optional[str]
    transaction_type: TransactionType
    status: TransactionStatus
    payment_method: Optional[PaymentMethod]
    merchant_name: Optional[str]
    location: Optional[str]
    device_info: Optional[str]
    created_at: datetime
    completed_at: Optional[datetime]
    user: UserOut
    class Config:
        orm_mode = True
