"""
Script pour exécuter la migration des tables de cartes virtuelles
"""
import pymysql
from dotenv import load_dotenv
import os

# Charger les variables d'environnement
load_dotenv('.env.mysql')

# Configuration de la base de données
DB_CONFIG = {
    'host': os.getenv('DB_HOST', 'localhost'),
    'port': int(os.getenv('DB_PORT', 3306)),
    'user': os.getenv('DB_USER', 'root'),
    'password': os.getenv('DB_PASSWORD', ''),
    'database': os.getenv('DB_NAME', 'timcash_db'),
    'charset': 'utf8mb4'
}

def run_migration():
    """Exécuter la migration SQL"""
    try:
        # Connexion à la base de données
        connection = pymysql.connect(**DB_CONFIG)
        cursor = connection.cursor()
        
        print("=" * 60)
        print("🚀 MIGRATION DES TABLES DE CARTES VIRTUELLES")
        print("=" * 60)
        
        # Lire le fichier SQL
        with open('migrations/create_virtual_cards_tables.sql', 'r', encoding='utf-8') as f:
            sql_content = f.read()

        # Nettoyer et séparer les commandes SQL
        lines = sql_content.split('\n')
        commands = []
        current_command = []

        for line in lines:
            # Ignorer les commentaires
            if line.strip().startswith('--') or not line.strip():
                continue

            current_command.append(line)

            # Si la ligne se termine par un point-virgule, c'est la fin de la commande
            if line.strip().endswith(';'):
                command = '\n'.join(current_command)
                commands.append(command)
                current_command = []

        print(f"\n📋 {len(commands)} commandes SQL à exécuter\n")

        # Exécuter chaque commande
        for i, command in enumerate(commands, 1):
            if command.strip():
                try:
                    # Afficher un aperçu de la commande
                    preview = command.strip()[:80].replace('\n', ' ')
                    print(f"📝 [{i}/{len(commands)}] {preview}...")

                    cursor.execute(command)
                    connection.commit()
                    print(f"✅ Commande {i} exécutée avec succès\n")
                except Exception as e:
                    print(f"⚠️ Avertissement commande {i}: {str(e)}\n")
                    # Continuer même en cas d'erreur (ex: table déjà existante)
        
        print("\n" + "=" * 60)
        print("✅ MIGRATION TERMINÉE AVEC SUCCÈS")
        print("=" * 60)
        
        # Vérifier les tables créées
        print("\n📊 Vérification des tables créées:")
        cursor.execute("SHOW TABLES LIKE 'virtual_card%'")
        tables = cursor.fetchall()
        for table in tables:
            print(f"  ✓ {table[0]}")
        
        # Vérifier les prix insérés
        print("\n💰 Prix des cartes virtuelles:")
        cursor.execute("SELECT card_color, base_price, is_premium FROM virtual_card_prices ORDER BY base_price")
        prices = cursor.fetchall()
        for color, price, is_premium in prices:
            premium_badge = "⭐ PREMIUM" if is_premium else ""
            print(f"  • {color.upper()}: {price} FCFA {premium_badge}")
        
        cursor.close()
        connection.close()
        
        print("\n🎉 Migration réussie ! Les tables de cartes virtuelles sont prêtes.")
        
    except Exception as e:
        print(f"\n❌ ERREUR LORS DE LA MIGRATION: {str(e)}")
        raise

if __name__ == "__main__":
    run_migration()

