"""create virtual_card_purchases

Revision ID: 29b8a4cc208d
Revises: 4fba06e262a0
Create Date: 2025-11-15 08:40:40.171316

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '29b8a4cc208d'
down_revision: Union[str, None] = '4fba06e262a0'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('cinetpay_transfers',
    sa.Column('id', sa.String(length=50), nullable=False),
    sa.Column('amount', sa.Float(), nullable=False),
    sa.Column('reference', sa.String(length=100), nullable=False),
    sa.Column('cinetpay_transaction_id', sa.String(length=100), nullable=True),
    sa.Column('status', sa.String(length=20), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('completed_at', sa.DateTime(), nullable=True),
    sa.Column('failed_at', sa.DateTime(), nullable=True),
    sa.Column('failure_reason', sa.Text(), nullable=True),
    sa.Column('notes', sa.Text(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('reference')
    )
    op.create_table('timcash_company_account',
    sa.Column('id', sa.String(length=50), nullable=False),
    sa.Column('balance', sa.Float(), nullable=True),
    sa.Column('total_commissions_received', sa.Float(), nullable=True),
    sa.Column('total_transferred_to_cinetpay', sa.Float(), nullable=True),
    sa.Column('total_recharges_count', sa.Integer(), nullable=True),
    sa.Column('last_recharge_at', sa.DateTime(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('virtual_card_prices',
    sa.Column('id', sa.String(), nullable=False),
    sa.Column('card_color', sa.Enum('gold', 'amber', 'green', 'infinite', 'silver', 'black', 'blue', 'red', 'purple', 'orange', name='virtualcardcolor'), nullable=False),
    sa.Column('base_price', sa.Float(), nullable=False),
    sa.Column('tim_mini_price', sa.Float(), nullable=True),
    sa.Column('tim_maxi_price', sa.Float(), nullable=True),
    sa.Column('tim_business_price', sa.Float(), nullable=True),
    sa.Column('commission_rate', sa.Float(), nullable=True),
    sa.Column('is_available', sa.Boolean(), nullable=True),
    sa.Column('is_premium', sa.Boolean(), nullable=True),
    sa.Column('max_purchases_per_user', sa.Integer(), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('card_color')
    )
    op.create_index(op.f('ix_virtual_card_prices_id'), 'virtual_card_prices', ['id'], unique=False)
    op.create_table('tim_business_recharges',
    sa.Column('id', sa.String(length=50), nullable=False),
    sa.Column('business_user_id', sa.String(length=50), nullable=False),
    sa.Column('business_account_type', sa.String(length=20), nullable=True),
    sa.Column('beneficiary_user_id', sa.String(length=50), nullable=False),
    sa.Column('beneficiary_phone', sa.String(length=20), nullable=False),
    sa.Column('beneficiary_account_type', sa.String(length=20), nullable=False),
    sa.Column('amount', sa.Float(), nullable=False),
    sa.Column('total_commission', sa.Float(), nullable=False),
    sa.Column('business_commission', sa.Float(), nullable=False),
    sa.Column('timcash_commission', sa.Float(), nullable=False),
    sa.Column('total_amount', sa.Float(), nullable=False),
    sa.Column('business_balance_before', sa.Float(), nullable=False),
    sa.Column('business_balance_after', sa.Float(), nullable=False),
    sa.Column('beneficiary_balance_before', sa.Float(), nullable=False),
    sa.Column('beneficiary_balance_after', sa.Float(), nullable=False),
    sa.Column('status', sa.Enum('PENDING', 'PROCESSING', 'COMPLETED', 'FAILED', 'CANCELLED', 'REFUNDED', name='rechargestatus'), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('completed_at', sa.DateTime(), nullable=True),
    sa.Column('failed_at', sa.DateTime(), nullable=True),
    sa.Column('reference', sa.String(length=100), nullable=False),
    sa.Column('description', sa.Text(), nullable=True),
    sa.Column('failure_reason', sa.Text(), nullable=True),
    sa.Column('ip_address', sa.String(length=50), nullable=True),
    sa.Column('device_info', sa.Text(), nullable=True),
    sa.Column('location', sa.String(length=100), nullable=True),
    sa.ForeignKeyConstraint(['beneficiary_user_id'], ['users.id'], ),
    sa.ForeignKeyConstraint(['business_user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('reference')
    )
    op.create_table('recharge_commissions',
    sa.Column('id', sa.String(length=50), nullable=False),
    sa.Column('recharge_id', sa.String(length=50), nullable=False),
    sa.Column('commission_type', sa.Enum('TIM_BUSINESS', 'TIM_CASH', name='commissiontype'), nullable=False),
    sa.Column('recipient_user_id', sa.String(length=50), nullable=True),
    sa.Column('recipient_type', sa.String(length=20), nullable=False),
    sa.Column('amount', sa.Float(), nullable=False),
    sa.Column('percentage', sa.Float(), nullable=False),
    sa.Column('status', sa.String(length=20), nullable=True),
    sa.Column('credited_at', sa.DateTime(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('notes', sa.Text(), nullable=True),
    sa.ForeignKeyConstraint(['recharge_id'], ['tim_business_recharges.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('virtual_card_purchases',
    sa.Column('id', sa.String(), nullable=False),
    sa.Column('user_id', sa.String(), nullable=False),
    sa.Column('card_color', sa.Enum('gold', 'amber', 'green', 'infinite', 'silver', 'black', 'blue', 'red', 'purple', 'orange', name='virtualcardcolor'), nullable=False),
    sa.Column('card_id', sa.String(), nullable=True),
    sa.Column('amount', sa.Float(), nullable=False),
    sa.Column('commission_amount', sa.Float(), nullable=True),
    sa.Column('total_amount', sa.Float(), nullable=False),
    sa.Column('status', sa.Enum('pending', 'payment_initiated', 'payment_completed', 'card_created', 'failed', 'cancelled', name='virtualcardpurchasestatus'), nullable=True),
    sa.Column('payment_transaction_id', sa.String(), nullable=True),
    sa.Column('cinetpay_transaction_id', sa.String(), nullable=True),
    sa.Column('cinetpay_payment_url', sa.Text(), nullable=True),
    sa.Column('cinetpay_payment_token', sa.String(), nullable=True),
    sa.Column('payment_method', sa.String(), nullable=True),
    sa.Column('payment_phone', sa.String(), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('payment_initiated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('payment_completed_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('card_created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('failed_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('failure_reason', sa.Text(), nullable=True),
    sa.Column('device_info', sa.Text(), nullable=True),
    sa.Column('ip_address', sa.String(), nullable=True),
    sa.ForeignKeyConstraint(['card_id'], ['nfc_cards.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_virtual_card_purchases_id'), 'virtual_card_purchases', ['id'], unique=False)
    op.create_index(op.f('ix_virtual_card_purchases_payment_transaction_id'), 'virtual_card_purchases', ['payment_transaction_id'], unique=True)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_virtual_card_purchases_payment_transaction_id'), table_name='virtual_card_purchases')
    op.drop_index(op.f('ix_virtual_card_purchases_id'), table_name='virtual_card_purchases')
    op.drop_table('virtual_card_purchases')
    op.drop_table('recharge_commissions')
    op.drop_table('tim_business_recharges')
    op.drop_index(op.f('ix_virtual_card_prices_id'), table_name='virtual_card_prices')
    op.drop_table('virtual_card_prices')
    op.drop_table('timcash_company_account')
    op.drop_table('cinetpay_transfers')
    # ### end Alembic commands ###
