"""
Script pour vider toutes les transactions de type recharge
"""
import sys
import os
sys.path.append(os.path.dirname(os.path.abspath(__file__)))

from database import SessionLocal
from models import Transaction, TransactionType

print("\n" + "="*60)
print("SUPPRESSION DES RECHARGES")
print("="*60)

db = SessionLocal()

try:
    # Types de recharge à supprimer
    recharge_types = [
        TransactionType.RECHARGE_CINETPAY,
        TransactionType.RECHARGE_BY_BUSINESS
    ]
    
    # Compter les recharges avant suppression
    count_before = db.query(Transaction).filter(
        Transaction.transaction_type.in_(recharge_types)
    ).count()
    
    print(f"\n📊 Nombre de recharges avant: {count_before}")
    
    if count_before == 0:
        print("✅ Aucune recharge à supprimer!")
    else:
        # Supprimer toutes les recharges
        deleted = db.query(Transaction).filter(
            Transaction.transaction_type.in_(recharge_types)
        ).delete(synchronize_session=False)
        
        db.commit()
        
        print(f"🗑️  {deleted} recharge(s) supprimée(s)")
        
        # Vérifier après suppression
        count_after = db.query(Transaction).filter(
            Transaction.transaction_type.in_(recharge_types)
        ).count()
        
        print(f"📊 Nombre de recharges après: {count_after}")
        
        if count_after == 0:
            print("\n✅ Toutes les recharges ont été supprimées!")
        else:
            print(f"\n⚠️  Il reste encore {count_after} recharge(s)")
    
    # Afficher le total des transactions restantes
    total_transactions = db.query(Transaction).count()
    print(f"\n📈 Total transactions restantes: {total_transactions}")
    
    print("="*60 + "\n")
    
except Exception as e:
    print(f"\n❌ Erreur: {str(e)}")
    db.rollback()
finally:
    db.close()
