"""
Script pour vider toutes les données de la table admin_stock
"""
import sys
import os
sys.path.append(os.path.dirname(os.path.abspath(__file__)))

from database import SessionLocal
from models import AdminStock

print("\n" + "="*60)
print("SUPPRESSION DES DONNÉES ADMIN STOCK")
print("="*60)

db = SessionLocal()

try:
    # Compter les enregistrements avant suppression
    count_before = db.query(AdminStock).count()
    print(f"\n📊 Nombre d'enregistrements avant: {count_before}")
    
    if count_before == 0:
        print("✅ La table admin_stock est déjà vide!")
    else:
        # Supprimer tous les enregistrements
        deleted = db.query(AdminStock).delete()
        db.commit()
        
        print(f"🗑️  {deleted} enregistrement(s) supprimé(s)")
        
        # Vérifier après suppression
        count_after = db.query(AdminStock).count()
        print(f"📊 Nombre d'enregistrements après: {count_after}")
        
        if count_after == 0:
            print("\n✅ Table admin_stock vidée avec succès!")
        else:
            print(f"\n⚠️  Il reste encore {count_after} enregistrement(s)")
    
    print("="*60 + "\n")
    
except Exception as e:
    print(f"\n❌ Erreur: {str(e)}")
    db.rollback()
finally:
    db.close()
