from fastapi import FastAPI, HTTPException, Depends
from sqlalchemy.orm import Session
from models.m import User
from database import get_db # Assure-toi que tes imports sont corrects

app = FastAPI()

@app.post("/financials/auth/user/confirm-otp")
async def confirm_otp(otp: str, db: Session = Depends(get_db)):
    # Cherche l'utilisateur avec l'OTP correspondant
    user = db.query(User).filter(User.otp_secret == otp).first()
    
    if not user:
        raise HTTPException(status_code=404, detail="Utilisateur non trouvé ou OTP invalide")
    
    # Active l'utilisateur
    user.is_active = True
    db.add(user)
    db.commit()
    db.refresh(user)
    
    return {
        "id": user.id,
        "phone_number": user.phone_number,
        "is_active": user.is_active
    }

# --- Snippet pour tester en REPL ---
if __name__ == "__main__":
    db = next(get_db())  # récupère une session
    otp_test = "7594"
    user = db.query(User).filter(User.otp_secret == otp_test).first()
    if user:
        print("Utilisateur trouvé :", user.phone_number, user.otp_secret, user.is_active)
    else:
        print("Aucun utilisateur trouvé pour l'OTP", otp_test)
