from sqlalchemy import Column, String, DateTime, Boolean, Integer, ForeignKey
from sqlalchemy.orm import relationship
from sqlalchemy.sql import func
from .database import Base

class Card(Base):
    __tablename__ = "cards"
    
    id = Column(String(8), primary_key=True, index=True)  # ID à 8 chiffres
    uid = Column(String(50), unique=True, nullable=False, index=True)  # UID NFC de la carte
    user_id = Column(String, ForeignKey("users.id"), nullable=False)
    status = Column(String(20), default="active")  # active, blocked, lost, stolen
    created_at = Column(DateTime(timezone=True), server_default=func.now())
    updated_at = Column(DateTime(timezone=True), onupdate=func.now())
    
    # Relations
    user = relationship("User", back_populates="cards")
    
    def __repr__(self):
        return f"<Card(id={self.id}, uid={self.uid}, user_id={self.user_id}, status={self.status})>"
