"""add prelevement request notifications

Revision ID: 7a843239a797
Revises: 6e7455713615
Create Date: 2025-11-24 02:00:04.386716

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '7a843239a797'
down_revision: Union[str, None] = '6e7455713615'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('notifications_transaction_id_fkey', 'notifications', type_='foreignkey')
    op.create_foreign_key(None, 'notifications', 'prelevement', ['transaction_id'], ['id'])
    op.add_column('prelevement', sa.Column('notifications_id', sa.String(), nullable=True))
    op.create_foreign_key(None, 'prelevement', 'notifications', ['notifications_id'], ['id'])
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'prelevement', type_='foreignkey')
    op.drop_column('prelevement', 'notifications_id')
    op.drop_constraint(None, 'notifications', type_='foreignkey')
    op.create_foreign_key('notifications_transaction_id_fkey', 'notifications', 'transactions', ['transaction_id'], ['id'])
    # ### end Alembic commands ###
