"""create virtual_card_purchases card

Revision ID: 3a6e1ff319cc
Revises: 03553c1405a6
Create Date: 2025-11-16 07:10:51.054877

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '3a6e1ff319cc'
down_revision: Union[str, None] = '03553c1405a6'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('cards_virtual_user',
    sa.Column('id', sa.String(length=8), nullable=False),
    sa.Column('user_id', sa.String(), nullable=False),
    sa.Column('card_id', sa.String(length=8), nullable=False),
    sa.Column('acquired_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.ForeignKeyConstraint(['card_id'], ['cards_virtual.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_cards_virtual_user_id'), 'cards_virtual_user', ['id'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_cards_virtual_user_id'), table_name='cards_virtual_user')
    op.drop_table('cards_virtual_user')
    # ### end Alembic commands ###
