@echo off
REM Script de migration TIM CASH - SQLite vers MySQL
REM Windows Batch Script

echo ========================================
echo Migration TIM CASH: SQLite vers MySQL
echo ========================================
echo.

REM Vérifier que Python est installé
python --version >nul 2>&1
if errorlevel 1 (
    echo [ERREUR] Python n'est pas installe ou n'est pas dans le PATH
    echo Installez Python depuis: https://www.python.org/downloads/
    pause
    exit /b 1
)

echo [OK] Python est installe
echo.

REM Étape 1: Vérifier l'état
echo ========================================
echo ETAPE 1: Verification de l'etat
echo ========================================
echo.
python check_mysql_status.py

echo.
echo Verification terminee. Consultez les resultats ci-dessus.
echo.

REM Demander à l'utilisateur si MySQL est prêt
set /p mysql_ready="MySQL est-il installe et configure ? (O/N): "
if /i not "%mysql_ready%"=="O" (
    echo.
    echo MySQL n'est pas pret. Veuillez d'abord:
    echo 1. Installer MySQL: https://dev.mysql.com/downloads/installer/
    echo 2. Configurer MySQL: python setup_mysql_interactive.py
    echo.
    pause
    exit /b 1
)

echo.
echo ========================================
echo ETAPE 2: Configuration MySQL
echo ========================================
echo.
set /p configure="Voulez-vous configurer MySQL maintenant ? (O/N): "
if /i "%configure%"=="O" (
    python setup_mysql_interactive.py
    if errorlevel 1 (
        echo [ERREUR] La configuration a echoue
        pause
        exit /b 1
    )
)

echo.
echo ========================================
echo ETAPE 3: Migration des donnees
echo ========================================
echo.
set /p migrate="Lancer la migration maintenant ? (O/N): "
if /i not "%migrate%"=="O" (
    echo Migration annulee.
    pause
    exit /b 0
)

echo.
echo Demarrage de la migration...
python migrate_sqlite_to_mysql.py
if errorlevel 1 (
    echo.
    echo [ERREUR] La migration a echoue
    echo Consultez les logs ci-dessus pour plus de details.
    pause
    exit /b 1
)

echo.
echo ========================================
echo MIGRATION REUSSIE !
echo ========================================
echo.
echo Prochaines etapes:
echo 1. Tester: python test_extended_tables.py
echo 2. Demarrer: python -m uvicorn main:app --reload --port 8001
echo 3. API: http://localhost:8001/docs
echo.
pause
