"""
Script pour initialiser les commissions par défaut
"""
from database import SessionLocal
from services.commission_service import CommissionService
from models import User

def initialize_commissions():
    """Initialiser les commissions par défaut"""
    db = SessionLocal()
    try:
        # Trouver un utilisateur admin
        admin_user = db.query(User).filter(User.is_admin == True).first()
        if not admin_user:
            print("Aucun utilisateur admin trouvé. Création d'un admin par défaut...")
            # Créer un admin par défaut
            admin_user = User(
                id="admin-default",
                email="admin@timcash.com",
                full_name="Administrateur TimCash",
                phone="+22500000000",
                is_admin=True,
                is_active=True,
                country_id="CI"  # Côte d'Ivoire par défaut
            )
            db.add(admin_user)
            db.commit()
            db.refresh(admin_user)
        
        # Initialiser les commissions
        CommissionService.initialize_default_commissions(db, admin_user.id)
        
        print("✅ Commissions initialisées avec succès!")
        print("📊 Taux par défaut:")
        print("   - Recharge mobile money: 3% (1% CinetPay + 2% TimCash)")
        print("   - Intérêt prêt: 6%")
        print("   - Pénalité retard: 15%")
        
    except Exception as e:
        print(f"❌ Erreur lors de l'initialisation: {str(e)}")
        db.rollback()
    finally:
        db.close()

if __name__ == "__main__":
    initialize_commissions()
