"""
Script pour vider tous les prêts
"""
import sys
import os
sys.path.append(os.path.dirname(os.path.abspath(__file__)))

from database import SessionLocal
from models.models import Loan

print("\n" + "="*60)
print("SUPPRESSION DES PRÊTS")
print("="*60)

db = SessionLocal()

try:
    # Compter les prêts avant suppression
    count_before = db.query(Loan).count()
    
    print(f"\n📊 Nombre de prêts avant: {count_before}")
    
    if count_before == 0:
        print("✅ Aucun prêt à supprimer!")
    else:
        # Supprimer tous les prêts
        deleted = db.query(Loan).delete()
        db.commit()
        
        print(f"🗑️  {deleted} prêt(s) supprimé(s)")
        
        # Vérifier après suppression
        count_after = db.query(Loan).count()
        print(f"📊 Nombre de prêts après: {count_after}")
        
        if count_after == 0:
            print("\n✅ Tous les prêts ont été supprimés!")
        else:
            print(f"\n⚠️  Il reste encore {count_after} prêt(s)")
    
    print("="*60 + "\n")
    
except Exception as e:
    print(f"\n❌ Erreur: {str(e)}")
    db.rollback()
finally:
    db.close()
