
from datetime import datetime, timedelta
import json
from typing import Annotated

from models.models import AdminUser
from schemas.admin import AdminCreateRequest, LoginSchemaAdmin, AdminResponse
from services.admin_service import create_admin_count, login_admin
from utility.auth_token import get_current_admin
from utility.send_email import send_mail
from core.excption import NotFoundException
from fastapi import APIRouter, BackgroundTasks, Depends, File, HTTPException, Request, UploadFile, status
from core.config import settings
from database import get_db
from sqlalchemy.orm import Session
from fastapi.responses import JSONResponse
import logging
logger = logging.getLogger(__name__)

router = APIRouter()

@router.post("/auth/admin/login")
async def login_admin_account(request: Request, payload: LoginSchemaAdmin, db: Session = Depends(get_db)):
    logger.info(f"Login attempt at {datetime.utcnow().isoformat()} payload {payload} from {request.client.host}")
    return await login_admin(payload, db)

@router.post("/auth/admin/create")
async def create_admin(request: Request, payload: AdminCreateRequest, db: Session = Depends(get_db)):
    logger.info(f"Admin creation attempt at {datetime.utcnow().isoformat()} payload {payload} from {request.client.host}")
    return await create_admin_count(payload, db)


@router.get("/auth/admin/profile", response_model=AdminResponse)
async def get_admin_profile(current_admin: Annotated[AdminUser, Depends(get_current_admin)]):
    return {
        "id": current_admin.id,
        "email": current_admin.email,
        "full_name": current_admin.full_name,
        "phone_number": current_admin.phone_number,
        "is_admin": current_admin.is_admin,
        "role": current_admin.role,
        "active": current_admin.active,
        "created_at": current_admin.created_at,
        "updated_at": current_admin.updated_at
    }

