"""Initial migration

Revision ID: f68fa49ae81a
Revises: 
Create Date: 2025-11-10 18:42:52.620542

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'f68fa49ae81a'
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('admin_stock',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('balance', sa.Float(), nullable=True),
    sa.Column('total_credits', sa.Float(), nullable=True),
    sa.Column('total_debits', sa.Float(), nullable=True),
    sa.Column('total_commissions', sa.Float(), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_admin_stock_id'), 'admin_stock', ['id'], unique=False)
    op.create_table('advertisements',
    sa.Column('id', sa.String(), nullable=False),
    sa.Column('title', sa.String(), nullable=False),
    sa.Column('description', sa.Text(), nullable=True),
    sa.Column('image_url', sa.String(), nullable=True),
    sa.Column('ad_type', sa.String(), nullable=True),
    sa.Column('status', sa.String(), nullable=True),
    sa.Column('target_countries', sa.Text(), nullable=True),
    sa.Column('target_cities', sa.Text(), nullable=True),
    sa.Column('start_date', sa.DateTime(timezone=True), nullable=True),
    sa.Column('end_date', sa.DateTime(timezone=True), nullable=True),
    sa.Column('budget', sa.Float(), nullable=True),
    sa.Column('spent', sa.Float(), nullable=True),
    sa.Column('impressions', sa.Integer(), nullable=True),
    sa.Column('clicks', sa.Integer(), nullable=True),
    sa.Column('ctr', sa.Float(), nullable=True),
    sa.Column('created_by', sa.String(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_advertisements_id'), 'advertisements', ['id'], unique=False)
    op.create_table('commission_rates',
    sa.Column('id', sa.String(), nullable=False),
    sa.Column('name', sa.String(), nullable=False),
    sa.Column('rate_type', sa.String(), nullable=False),
    sa.Column('value', sa.Float(), nullable=False),
    sa.Column('category', sa.String(), nullable=False),
    sa.Column('description', sa.Text(), nullable=True),
    sa.Column('min_amount', sa.Float(), nullable=True),
    sa.Column('max_amount', sa.Float(), nullable=True),
    sa.Column('is_active', sa.Boolean(), nullable=True),
    sa.Column('updated_by', sa.String(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_commission_rates_id'), 'commission_rates', ['id'], unique=False)
    op.create_table('countries',
    sa.Column('id', sa.String(), nullable=False),
    sa.Column('name', sa.String(), nullable=False),
    sa.Column('code', sa.String(length=3), nullable=False),
    sa.Column('currency', sa.String(), nullable=True),
    sa.Column('currency_symbol', sa.String(), nullable=True),
    sa.Column('flag', sa.String(), nullable=True),
    sa.Column('is_active', sa.Boolean(), nullable=True),
    sa.Column('total_users', sa.Integer(), nullable=True),
    sa.Column('total_volume', sa.Float(), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('code')
    )
    op.create_index(op.f('ix_countries_id'), 'countries', ['id'], unique=False)
    op.create_table('device_capabilities',
    sa.Column('id', sa.String(), nullable=False),
    sa.Column('device_model', sa.String(), nullable=False),
    sa.Column('brand', sa.String(), nullable=False),
    sa.Column('has_nfc', sa.Boolean(), nullable=True),
    sa.Column('nfc_enabled', sa.Boolean(), nullable=True),
    sa.Column('os_version', sa.String(), nullable=True),
    sa.Column('user_count', sa.Integer(), nullable=True),
    sa.Column('transaction_count', sa.Integer(), nullable=True),
    sa.Column('success_rate', sa.Float(), nullable=True),
    sa.Column('location', sa.String(), nullable=True),
    sa.Column('country', sa.String(), nullable=True),
    sa.Column('city', sa.String(), nullable=True),
    sa.Column('last_seen', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_device_capabilities_id'), 'device_capabilities', ['id'], unique=False)
    op.create_table('workflows',
    sa.Column('id', sa.String(), nullable=False),
    sa.Column('name', sa.String(), nullable=False),
    sa.Column('description', sa.Text(), nullable=True),
    sa.Column('status', sa.String(), nullable=True),
    sa.Column('category', sa.String(), nullable=False),
    sa.Column('triggers', sa.Integer(), nullable=True),
    sa.Column('executions', sa.Integer(), nullable=True),
    sa.Column('success_rate', sa.Float(), nullable=True),
    sa.Column('steps', sa.Text(), nullable=True),
    sa.Column('last_run', sa.DateTime(timezone=True), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_workflows_id'), 'workflows', ['id'], unique=False)
    op.create_table('cities',
    sa.Column('id', sa.String(), nullable=False),
    sa.Column('name', sa.String(), nullable=False),
    sa.Column('country_id', sa.String(), nullable=False),
    sa.Column('branch_code', sa.String(), nullable=True),
    sa.Column('is_active', sa.Boolean(), nullable=True),
    sa.Column('users', sa.Integer(), nullable=True),
    sa.Column('volume', sa.Float(), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.ForeignKeyConstraint(['country_id'], ['countries.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('branch_code')
    )
    op.create_index(op.f('ix_cities_id'), 'cities', ['id'], unique=False)
    op.create_table('users',
    sa.Column('id', sa.String(), nullable=False),
    sa.Column('email', sa.String(), nullable=False),
    sa.Column('username', sa.String(), nullable=True),
    sa.Column('full_name', sa.String(), nullable=True),
    sa.Column('last_name', sa.String(), nullable=True),
    sa.Column('genre', sa.Enum('HOMME', 'FEMME', 'AUTRE', name='genreenum'), nullable=True),
    sa.Column('date_naissance', sa.Date(), nullable=True),
    sa.Column('phone', sa.String(), nullable=True),
    sa.Column('hashed_password', sa.String(), nullable=True),
    sa.Column('commission_payee', sa.Boolean(), nullable=True),
    sa.Column('photo_profile', sa.String(), nullable=True),
    sa.Column('photo_recto', sa.String(), nullable=True),
    sa.Column('photo_verso', sa.String(), nullable=True),
    sa.Column('is_active', sa.Boolean(), nullable=True),
    sa.Column('otp_secret', sa.String(), nullable=True),
    sa.Column('is_admin', sa.Boolean(), nullable=True),
    sa.Column('tim_account_type', sa.Enum('TIM_MINI', 'TIM_MAXI', 'TIM_BUSINESS', name='timaccounttype'), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('country_id', sa.String(), nullable=False),
    sa.ForeignKeyConstraint(['country_id'], ['countries.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_users_email'), 'users', ['email'], unique=True)
    op.create_index(op.f('ix_users_id'), 'users', ['id'], unique=False)
    op.create_index(op.f('ix_users_phone'), 'users', ['phone'], unique=True)
    op.create_index(op.f('ix_users_username'), 'users', ['username'], unique=True)
    op.create_table('cards',
    sa.Column('id', sa.String(length=8), nullable=False),
    sa.Column('uid', sa.String(length=50), nullable=False),
    sa.Column('user_id', sa.String(), nullable=False),
    sa.Column('status', sa.String(length=20), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_cards_id'), 'cards', ['id'], unique=False)
    op.create_index(op.f('ix_cards_uid'), 'cards', ['uid'], unique=True)
    op.create_table('loans',
    sa.Column('id', sa.String(), nullable=False),
    sa.Column('user_id', sa.String(), nullable=False),
    sa.Column('amount', sa.Float(), nullable=False),
    sa.Column('interest_rate', sa.Float(), nullable=True),
    sa.Column('penalty_rate', sa.Float(), nullable=True),
    sa.Column('remaining_balance', sa.Float(), nullable=False),
    sa.Column('monthly_payment', sa.Float(), nullable=False),
    sa.Column('total_payments', sa.Integer(), nullable=False),
    sa.Column('payments_completed', sa.Integer(), nullable=True),
    sa.Column('status', sa.Enum('PENDING', 'APPROVED', 'ACTIVE', 'COMPLETED', 'OVERDUE', 'REJECTED', name='loanstatus'), nullable=True),
    sa.Column('due_date', sa.DateTime(timezone=True), nullable=True),
    sa.Column('days_overdue', sa.Integer(), nullable=True),
    sa.Column('guarantee_deposit', sa.Float(), nullable=True),
    sa.Column('deposit_paid', sa.Boolean(), nullable=True),
    sa.Column('auto_approved', sa.Boolean(), nullable=True),
    sa.Column('wallet_credited', sa.Boolean(), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('approved_at', sa.DateTime(timezone=True), nullable=True),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_loans_id'), 'loans', ['id'], unique=False)
    op.create_table('nfc_cards',
    sa.Column('id', sa.String(), nullable=False),
    sa.Column('card_uid', sa.String(), nullable=False),
    sa.Column('card_number', sa.String(), nullable=False),
    sa.Column('user_id', sa.String(), nullable=False),
    sa.Column('card_type', sa.String(), nullable=True),
    sa.Column('status', sa.String(), nullable=True),
    sa.Column('balance', sa.Float(), nullable=True),
    sa.Column('max_balance', sa.Float(), nullable=True),
    sa.Column('is_primary', sa.Boolean(), nullable=True),
    sa.Column('last_used_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_nfc_cards_card_number'), 'nfc_cards', ['card_number'], unique=True)
    op.create_index(op.f('ix_nfc_cards_card_uid'), 'nfc_cards', ['card_uid'], unique=True)
    op.create_index(op.f('ix_nfc_cards_id'), 'nfc_cards', ['id'], unique=False)
    op.create_table('transactions',
    sa.Column('id', sa.String(), nullable=False),
    sa.Column('user_id', sa.String(), nullable=False),
    sa.Column('transaction_type', sa.Enum('NFC_DEPOSIT', 'NFC_WITHDRAWAL', 'RECHARGE_CINETPAY', 'RECHARGE_BY_BUSINESS', 'PRET_MOBILE', 'COMMISSION', 'REMBOURSEMENT_AUTO', 'VIREMENT_BANCAIRE', 'MOBILE_TRANSFER', 'PRELEVEMENT', 'DEPOT', 'RECHARGEMENT', 'RETRAIT', 'TRANSFERT', 'PAIEMENT', name='transactiontype'), nullable=False),
    sa.Column('amount', sa.Float(), nullable=False),
    sa.Column('commission_amount', sa.Float(), nullable=True),
    sa.Column('commission_rate', sa.Float(), nullable=True),
    sa.Column('status', sa.Enum('PENDING', 'COMPLETED', 'FAILED', 'CANCELLED', name='transactionstatus'), nullable=True),
    sa.Column('description', sa.Text(), nullable=True),
    sa.Column('reference', sa.String(), nullable=True),
    sa.Column('external_reference', sa.String(), nullable=True),
    sa.Column('payment_method', sa.Enum('MOBILE_MONEY', 'CARD', 'BANK_TRANSFER', name='paymentmethod'), nullable=True),
    sa.Column('merchant_name', sa.String(), nullable=True),
    sa.Column('location', sa.String(), nullable=True),
    sa.Column('device_info', sa.Text(), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('completed_at', sa.DateTime(timezone=True), nullable=True),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_transactions_id'), 'transactions', ['id'], unique=False)
    op.create_index(op.f('ix_transactions_reference'), 'transactions', ['reference'], unique=True)
    op.create_table('user_device_tokens',
    sa.Column('id', sa.String(), nullable=False),
    sa.Column('user_id', sa.String(), nullable=False),
    sa.Column('device_token', sa.String(), nullable=False),
    sa.Column('device_type', sa.String(), nullable=False),
    sa.Column('device_name', sa.String(), nullable=True),
    sa.Column('is_active', sa.Boolean(), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('last_used', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('device_token')
    )
    op.create_index(op.f('ix_user_device_tokens_id'), 'user_device_tokens', ['id'], unique=False)
    op.create_table('wallets',
    sa.Column('id', sa.String(), nullable=False),
    sa.Column('user_id', sa.String(), nullable=False),
    sa.Column('balance', sa.Float(), nullable=True),
    sa.Column('max_balance', sa.Float(), nullable=True),
    sa.Column('is_active', sa.Boolean(), nullable=True),
    sa.Column('nfc_enabled', sa.Boolean(), nullable=True),
    sa.Column('currency', sa.String(length=10), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('user_id')
    )
    op.create_index(op.f('ix_wallets_id'), 'wallets', ['id'], unique=False)
    op.create_table('nfc_card_transactions',
    sa.Column('id', sa.String(), nullable=False),
    sa.Column('card_id', sa.String(), nullable=False),
    sa.Column('transaction_id', sa.String(), nullable=False),
    sa.Column('operation_type', sa.String(), nullable=False),
    sa.Column('card_data', sa.Text(), nullable=True),
    sa.Column('device_info', sa.Text(), nullable=True),
    sa.Column('location', sa.String(), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.ForeignKeyConstraint(['card_id'], ['nfc_cards.id'], ),
    sa.ForeignKeyConstraint(['transaction_id'], ['transactions.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_nfc_card_transactions_id'), 'nfc_card_transactions', ['id'], unique=False)
    op.create_table('notifications',
    sa.Column('id', sa.String(), nullable=False),
    sa.Column('user_id', sa.String(), nullable=False),
    sa.Column('title', sa.String(), nullable=False),
    sa.Column('message', sa.Text(), nullable=False),
    sa.Column('type', sa.String(), nullable=False),
    sa.Column('priority', sa.Enum('LOW', 'MEDIUM', 'HIGH', name='notificationpriority'), nullable=True),
    sa.Column('is_read', sa.Boolean(), nullable=True),
    sa.Column('action_url', sa.String(), nullable=True),
    sa.Column('amount', sa.Float(), nullable=True),
    sa.Column('merchant', sa.String(), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('read_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('transaction_id', sa.String(), nullable=True),
    sa.Column('reference', sa.String(), nullable=True),
    sa.ForeignKeyConstraint(['transaction_id'], ['transactions.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_notifications_id'), 'notifications', ['id'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_notifications_id'), table_name='notifications')
    op.drop_table('notifications')
    op.drop_index(op.f('ix_nfc_card_transactions_id'), table_name='nfc_card_transactions')
    op.drop_table('nfc_card_transactions')
    op.drop_index(op.f('ix_wallets_id'), table_name='wallets')
    op.drop_table('wallets')
    op.drop_index(op.f('ix_user_device_tokens_id'), table_name='user_device_tokens')
    op.drop_table('user_device_tokens')
    op.drop_index(op.f('ix_transactions_reference'), table_name='transactions')
    op.drop_index(op.f('ix_transactions_id'), table_name='transactions')
    op.drop_table('transactions')
    op.drop_index(op.f('ix_nfc_cards_id'), table_name='nfc_cards')
    op.drop_index(op.f('ix_nfc_cards_card_uid'), table_name='nfc_cards')
    op.drop_index(op.f('ix_nfc_cards_card_number'), table_name='nfc_cards')
    op.drop_table('nfc_cards')
    op.drop_index(op.f('ix_loans_id'), table_name='loans')
    op.drop_table('loans')
    op.drop_index(op.f('ix_cards_uid'), table_name='cards')
    op.drop_index(op.f('ix_cards_id'), table_name='cards')
    op.drop_table('cards')
    op.drop_index(op.f('ix_users_username'), table_name='users')
    op.drop_index(op.f('ix_users_phone'), table_name='users')
    op.drop_index(op.f('ix_users_id'), table_name='users')
    op.drop_index(op.f('ix_users_email'), table_name='users')
    op.drop_table('users')
    op.drop_index(op.f('ix_cities_id'), table_name='cities')
    op.drop_table('cities')
    op.drop_index(op.f('ix_workflows_id'), table_name='workflows')
    op.drop_table('workflows')
    op.drop_index(op.f('ix_device_capabilities_id'), table_name='device_capabilities')
    op.drop_table('device_capabilities')
    op.drop_index(op.f('ix_countries_id'), table_name='countries')
    op.drop_table('countries')
    op.drop_index(op.f('ix_commission_rates_id'), table_name='commission_rates')
    op.drop_table('commission_rates')
    op.drop_index(op.f('ix_advertisements_id'), table_name='advertisements')
    op.drop_table('advertisements')
    op.drop_index(op.f('ix_admin_stock_id'), table_name='admin_stock')
    op.drop_table('admin_stock')
    # ### end Alembic commands ###
