from datetime import datetime
from fastapi import Form
from pydantic import BaseModel, EmailStr
from typing import Optional

class VirtualCardCreate(BaseModel):
    card_type: str
    price: float
    currency: str

class VirtualCardRead(BaseModel):
    id: str
    type_card: str
    price:  float
    currency: str
    created_at: datetime

    class Config:
        orm_mode = True
        
class BuyCardRequest(BaseModel):
    card_id: str