from fastapi import Form
from pydantic import BaseModel, EmailStr
from typing import Optional


class PreSignupRequest(BaseModel):
    email: EmailStr
    country_id: str
    city_id: str

class VerifyOtpRequest(BaseModel):
    otp: str
    email: EmailStr

class CompleteSignupRequest(BaseModel):
    email: EmailStr
    # username: str
    full_name: str
    last_name: str
    phone: str
    password: str
    genre: str
    tim_account_type: str
    

class UserUpdate(BaseModel):
    email: EmailStr
    username: str
    full_name: str
    phone: str
    profile_photo: str | None = None

    @classmethod
    def as_form(
        cls,
        email: EmailStr = Form(...),
        username: str = Form(...),
        full_name: str = Form(...),
        phone: str = Form(...),
        profile_photo: str = Form(None),
    ):
        return cls(
            email=email,
            username=username,
            full_name=full_name,
            phone=phone,
            profile_photo=profile_photo,
        )

    
class LoginSchema(BaseModel):
    phone: str
    country_id: str
    hashed_password: str

class TokenData(BaseModel):
    access_token: str
    refresh_token: str
    token_type: str
    
class LoginResponse(BaseModel):
    """
    Modèle de réponse pour la connexion utilisateur.
    Contient les tokens d'authentification après une connexion réussie.
    """
    success: bool
    data: TokenData
    
    class Config:
        from_attributes = True
        
class UserResponse(BaseModel):
    id: str
    email: str
    username: Optional[str]
    full_name: Optional[str]
    phone: Optional[str]
    is_active: bool

    class Config:
        orm_mode = True
        

class ForgotPasswordRequest(BaseModel):
    email: EmailStr

class VerifyOtpForgotRequest(BaseModel):
    email: EmailStr
    otp: str

class ResetPasswordRequest(BaseModel):
    email: EmailStr
    password: str
    confirmationCode: str