from pydantic import BaseModel
from typing import Optional
from datetime import datetime

class UserSchema(BaseModel):
    id: str
    email: str
    phone: Optional[str]
    full_name: Optional[str]

class PrelevementRequestSchema(BaseModel):
    id: str
    amount: float
    description: Optional[str]
    status: str
    created_at: datetime
    user: UserSchema