import httpx
import json
import uuid
import hashlib
from datetime import datetime, timezone
from fastapi import HTTPException, Depends, Request
from sqlalchemy.orm import Session
from pydantic import BaseModel, Field
from typing import Optional, Dict, Any
import os
from enum import Enum
from cinetpay_sdk.s_d_k import Cinetpay

# Configuration CinetPay (identique à votre Flutter)
CINETPAY_API_KEY = os.getenv("CINETPAY_API_KEY", "")
CINETPAY_SITE_ID = "5880897"
CINETPAY_BASE_URL = "https://api-checkout.cinetpay.com/v2"
CINETPAY_NOTIFY_URL = "https://yourapp.com/api/cinetpay/notify"
CINETPAY_RETURN_URL = "https://yourapp.com/payment/success"

import logging

logger = logging.getLogger(__name__)

class CinetPayService:
    """Service backend pour supporter votre implémentation Flutter"""
    
    def __init__(self):
        self.api_key = CINETPAY_API_KEY
        self.site_id = CINETPAY_SITE_ID
        self.base_url = CINETPAY_BASE_URL
        self.client  = Cinetpay(self.api_key,self.site_id)
    
   
    async def create_payment_url(self, transfer_data: Dict[str, Any]) -> Dict[str, Any]:
        """Crée l'URL de paiement CinetPay"""

        sdk = Cinetpay(self.api_key, self.site_id)

        # Appel API
        api_response = sdk.PaymentInitialization(transfer_data)

        print("Réponse brute CinetPay:", api_response)
        print("Envoie à CinetPay:", transfer_data)

        # Vérification format réponse
        if not isinstance(api_response, dict):
            raise HTTPException(
                status_code=500,
                detail="Réponse CinetPay invalide (non JSON)"
            )

        # Log infos
        print(f"Code: {api_response.get('code')}")
        print(f"Message: {api_response.get('message')}")

        # CinetPay renvoie : code = 201 => Créé
        if api_response.get("code") == "201":
            data = api_response.get("data", {})
            return {
                "success": True,
                "payment_url": data.get("payment_url"),
                "cinetpay_token": data.get("payment_token"),
                "message": "URL de paiement créée avec succès"
            }

        return {
            "success": False,
            "message": api_response.get("message", "Erreur inconnue CinetPay"),
        }

                        

# Instance du service
cinetpay_service = CinetPayService()
