"""
Schémas Pydantic pour les cartes physiques NFC
"""
from pydantic import BaseModel, Field
from typing import Optional
from datetime import datetime

class CardCreate(BaseModel):
    uid: str = Field(..., description="UID NFC de la carte")
    user_id: str = Field(..., description="ID de l'utilisateur")

class CardUpdate(BaseModel):
    status: Optional[str] = Field(None, description="Nouveau statut de la carte")
    reason: Optional[str] = Field(None, description="Raison du changement de statut")

class CardResponse(BaseModel):
    id: str
    uid: str
    user_id: str
    status: str
    created_at: datetime
    updated_at: Optional[datetime] = None
    
    # Informations utilisateur
    user_phone: Optional[str] = None
    user_name: Optional[str] = None
    
    class Config:
        from_attributes = True

class CardRechargeRequest(BaseModel):
    phone: str = Field(..., description="Numéro de téléphone de l'utilisateur")
    amount: float = Field(..., gt=0, description="Montant de la recharge")
    reason: Optional[str] = Field(None, description="Raison de la recharge")

class CardRechargeResponse(BaseModel):
    success: bool
    transaction_id: str
    card_id: str
    amount: float
    new_balance: float
    commission: dict

class CardBlockRequest(BaseModel):
    reason: str = Field(..., description="Raison du blocage")
    is_lost: bool = Field(False, description="Carte perdue")
    is_stolen: bool = Field(False, description="Carte volée")

class CardSearchRequest(BaseModel):
    query: str = Field(..., description="Terme de recherche (ID, UID, téléphone)")

class CardListResponse(BaseModel):
    cards: list[CardResponse]
    total: int
    page: int
    limit: int
