"""create virtual_card_purchases card

Revision ID: 49a2427a21b1
Revises: 37ff538a7b3f
Create Date: 2025-11-15 12:59:45.621198

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = '49a2427a21b1'
down_revision: Union[str, None] = '37ff538a7b3f'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('cards_virtual',
    sa.Column('id', sa.String(length=8), nullable=False),
    sa.Column('uid', sa.String(length=50), nullable=False),
    sa.Column('price', sa.Float(), nullable=True),
    sa.Column('type_card', sa.String(), nullable=False),
    sa.Column('currency', sa.String(), nullable=False),
    sa.Column('status', sa.String(length=20), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_cards_virtual_id'), 'cards_virtual', ['id'], unique=False)
    op.create_index(op.f('ix_cards_virtual_uid'), 'cards_virtual', ['uid'], unique=True)
    op.drop_index('ix_virtual_cards_id', table_name='virtual_cards')
    op.drop_table('virtual_cards')
    op.add_column('cards', sa.Column('uid', sa.String(length=50), nullable=False))
    op.add_column('cards', sa.Column('user_id', sa.String(), nullable=False))
    op.create_index(op.f('ix_cards_uid'), 'cards', ['uid'], unique=True)
    op.create_foreign_key(None, 'cards', 'users', ['user_id'], ['id'])
    op.drop_column('cards', 'currency')
    op.drop_column('cards', 'price')
    op.drop_column('cards', 'card_type')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('cards', sa.Column('card_type', sa.VARCHAR(length=20), autoincrement=False, nullable=False))
    op.add_column('cards', sa.Column('price', sa.INTEGER(), autoincrement=False, nullable=False))
    op.add_column('cards', sa.Column('currency', sa.VARCHAR(length=5), autoincrement=False, nullable=False))
    op.drop_constraint(None, 'cards', type_='foreignkey')
    op.drop_index(op.f('ix_cards_uid'), table_name='cards')
    op.drop_column('cards', 'user_id')
    op.drop_column('cards', 'uid')
    op.create_table('virtual_cards',
    sa.Column('id', sa.VARCHAR(length=8), autoincrement=False, nullable=False),
    sa.Column('user_id', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('created_at', postgresql.TIMESTAMP(), autoincrement=False, nullable=False),
    sa.Column('is_default', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], name='virtual_cards_user_id_fkey'),
    sa.PrimaryKeyConstraint('id', name='virtual_cards_pkey')
    )
    op.create_index('ix_virtual_cards_id', 'virtual_cards', ['id'], unique=False)
    op.drop_index(op.f('ix_cards_virtual_uid'), table_name='cards_virtual')
    op.drop_index(op.f('ix_cards_virtual_id'), table_name='cards_virtual')
    op.drop_table('cards_virtual')
    # ### end Alembic commands ###
