"""create virtual_card_purchases

Revision ID: 13d061734f56
Revises: 29b8a4cc208d
Create Date: 2025-11-15 10:29:12.180307

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '13d061734f56'
down_revision: Union[str, None] = '29b8a4cc208d'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('virtual_cards',
    sa.Column('id', sa.String(length=8), nullable=False),
    sa.Column('user_id', sa.String(), nullable=False),
    sa.Column('card_type', sa.String(length=20), nullable=False),
    sa.Column('balance', sa.Float(), nullable=False),
    sa.Column('price', sa.Integer(), nullable=False),
    sa.Column('currency', sa.String(length=5), nullable=False),
    sa.Column('created_at', sa.DateTime(), nullable=False),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_virtual_cards_id'), 'virtual_cards', ['id'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_virtual_cards_id'), table_name='virtual_cards')
    op.drop_table('virtual_cards')
    # ### end Alembic commands ###
