"""
Script pour supprimer les tables de cartes virtuelles avant de les recréer
"""
import pymysql
import sys

def drop_tables():
    try:
        # Connexion à la base de données
        connection = pymysql.connect(
            host='localhost',
            user='root',
            password='',
            database='timcash_db',
            charset='utf8mb4',
            cursorclass=pymysql.cursors.DictCursor
        )
        
        print("============================================================")
        print("🗑️  SUPPRESSION DES TABLES DE CARTES VIRTUELLES")
        print("============================================================\n")
        
        with connection.cursor() as cursor:
            # Supprimer les tables dans l'ordre (foreign keys)
            print("📝 Suppression de virtual_card_purchases...")
            cursor.execute("DROP TABLE IF EXISTS virtual_card_purchases")
            print("✅ virtual_card_purchases supprimée\n")
            
            print("📝 Suppression de virtual_card_prices...")
            cursor.execute("DROP TABLE IF EXISTS virtual_card_prices")
            print("✅ virtual_card_prices supprimée\n")
            
            # Vérifier si la colonne card_color existe avant de la supprimer
            print("📝 Vérification de la colonne card_color dans nfc_cards...")
            cursor.execute("""
                SELECT COUNT(*) as count 
                FROM information_schema.COLUMNS 
                WHERE TABLE_SCHEMA = 'timcash_db' 
                AND TABLE_NAME = 'nfc_cards' 
                AND COLUMN_NAME = 'card_color'
            """)
            result = cursor.fetchone()
            
            if result['count'] > 0:
                print("📝 Suppression de la colonne card_color...")
                cursor.execute("ALTER TABLE nfc_cards DROP COLUMN card_color")
                print("✅ Colonne card_color supprimée\n")
            else:
                print("ℹ️  Colonne card_color n'existe pas\n")
            
            # Vérifier si l'index existe avant de le supprimer
            print("📝 Vérification de l'index idx_card_color...")
            cursor.execute("""
                SELECT COUNT(*) as count 
                FROM information_schema.STATISTICS 
                WHERE TABLE_SCHEMA = 'timcash_db' 
                AND TABLE_NAME = 'nfc_cards' 
                AND INDEX_NAME = 'idx_card_color'
            """)
            result = cursor.fetchone()
            
            if result['count'] > 0:
                print("📝 Suppression de l'index idx_card_color...")
                cursor.execute("DROP INDEX idx_card_color ON nfc_cards")
                print("✅ Index idx_card_color supprimé\n")
            else:
                print("ℹ️  Index idx_card_color n'existe pas\n")
            
            connection.commit()
        
        print("============================================================")
        print("✅ SUPPRESSION TERMINÉE AVEC SUCCÈS")
        print("============================================================\n")
        print("Vous pouvez maintenant exécuter run_virtual_card_migration.py\n")
        
        connection.close()
        
    except Exception as e:
        print(f"\n❌ ERREUR: {str(e)}")
        sys.exit(1)

if __name__ == "__main__":
    drop_tables()

