"""
Script cron pour vérifier et bloquer les comptes avec prêts en retard

Ce script doit être exécuté quotidiennement (ex: via cron job)
Exemple cron: 0 0 * * * cd /path/to/backend && python cron_check_overdue_loans.py
"""
import sys
from datetime import datetime
from sqlalchemy.orm import Session
from database import SessionLocal
from services.loan_auto_repayment import LoanAutoRepaymentService

def check_overdue_loans():
    """Vérifier et bloquer les comptes avec prêts en retard"""
    db: Session = SessionLocal()
    
    try:
        print(f"🔍 Vérification des prêts en retard - {datetime.utcnow()}")
        print("=" * 60)
        
        # Vérifier et bloquer les comptes en retard
        result = LoanAutoRepaymentService.check_and_block_overdue_accounts(db)
        
        print("\n📊 RÉSULTAT:")
        print(f"   • Prêts en retard: {result['total_overdue_loans']}")
        print(f"   • Comptes bloqués: {result['accounts_blocked']}")
        
        if result['accounts_blocked'] > 0:
            print(f"\n⚠️  {result['accounts_blocked']} compte(s) ont été bloqué(s)")
        else:
            print("\n✅ Aucun compte à bloquer")
        
        print("=" * 60)
        print("✅ Vérification terminée\n")
        
    except Exception as e:
        print(f"❌ Erreur lors de la vérification: {e}")
        import traceback
        traceback.print_exc()
        sys.exit(1)
    finally:
        db.close()

if __name__ == "__main__":
    check_overdue_loans()

