import os
from dotenv import load_dotenv

from pathlib import Path

env_path = Path('.') / '.env'
load_dotenv(dotenv_path=env_path)
class Settings:
    PROJECT_NAME : str = "API PROJET  🔥"
    PROJECT_VERSION: str = "1.0.0"
    
    POSTGRES_USER: str = os.getenv("POSTGRES_USER")
    POSTGRES_PASSWORD: str = os.getenv("POSTGRES_PASSWORD")
    POSTGRES_SERVER: str = os.getenv("POSTGRES_SERVER")
    POSTGRES_PORT: str = os.getenv("POSTGRES_PORT")
    POSTGRES_DB: str = os.getenv("POSTGRES_DB")

    # Crée DATABASE_URL après avoir récupéré toutes les variables
    DATABASE_URL: str = f"postgresql://{os.getenv('POSTGRES_USER')}:{os.getenv('POSTGRES_PASSWORD')}@{os.getenv('POSTGRES_SERVER')}:{os.getenv('POSTGRES_PORT')}/{os.getenv('POSTGRES_DB')}"
    #Credentiel payment
    
    BASE_URL_PAYMENT = os.getenv("BASE_URL_PAYMENT")
    NAME_SERVICE = os.getenv("NAME_SERVICE")
    AUTHENTICATION_TOKEN = os.getenv("AUTHENTICATION_TOKEN")
    OPERATION_TOKEN = os.getenv("OPERATION_TOKEN")
    
    SECRET_KEY = os.getenv(
    "SECRET_KEY",
    "sraGbRmjYQXmYdnrgPk!OFE35UP6n/QqeoED=iu/bUXBFSSPwnsuprP6T45Qsbwywu2khUka!6IIleY",
)
    if not SECRET_KEY:
        SECRET_KEY = os.urandom(32)
        
    ACCESS_TOKEN_EXPIRE_MINUTES = 60
    ALGORITHM = "HS256"
    ACCESS_TOKEN_EXPIRES_MINUTES = 60  # 1 hour
    
    REFRESH_TOKEN_EXPIRES_MINUTES =  15
    BASE_URL_FILE = os.getenv("BASE_URL_FILE","http://192.168.1.87:8001")
    
    
    MAIL_USERNAME:str = os.getenv("MAIL_USERNAME")
    MAIL_PASSWORD:str = os.getenv("MAIL_PASSWORD")
    MAIL_PORT:int = os.getenv("MAIL_PORT")
    MAIL_SERVER:str = os.getenv("MAIL_SERVER")
    MAIL_SSL_TLS:bool = os.getenv("MAIL_TLS")
    MAIL_SSL_TLS:bool = os.getenv("MAIL_SSL")
    MAIL_FROM:str = os.getenv("MAIL_FROM")
    
    #MAP
    
    GOOGLE_MAPS_API_KEY: str = os.getenv("GOOGLE_MAPS_API_KEY")

    PRIMARY_MOMO_KEY: str = os.getenv("PRIMARY_MOMO_KEY")
    SECOND_MOMO_KEY_MOMO_KEY: str = os.getenv("SECOND_MOMO_KEY_MOMO_KEY")

    #URL CINETPAY
    CINETPAY_CALLBACK_URL=os.getenv("CINETPAY_CALLBACK_URL")
    CINETPAY_URL=os.getenv("CINETPAY_URL","https://secure.cinetpay.com")
    
    """Configuration des paramètres de l'application."""
    APP_BASE_URL: str = os.getenv("APP_BASE_URL")
    APP_BASE_WEB: str = os.getenv("APP_BASE_WEB")

settings = Settings()

