from fastapi import APIRouter
from api.v1 import route_countries
from api.v1 import route_users
from api.v1 import route_transaction
from api.v1 import notification_route
from api.v1 import route_loands
from api.v1 import route_commission
from api.v1 import route_nfc_card
from api.v1 import route_nfc_transaction
from api.v1 import route_card
from api.v1 import route_mobile_money
from api.v1 import route_transfers
from api.v1 import route_virtual_card
from api.v1 import route_upload_file
from api.v1 import route_admin

api_router = APIRouter()

api_router.include_router(route_countries.router, prefix="/api", tags=["countries"])
api_router.include_router(route_users.router, prefix="/api", tags=["users"])
api_router.include_router(route_transaction.router, prefix="/api", tags=["transactions"])
api_router.include_router(notification_route.router, prefix="/api", tags=["notifications"])
api_router.include_router(route_loands.router, prefix="/api", tags=["loans"])
api_router.include_router(route_commission.router, prefix="/api", tags=["commissions"])
api_router.include_router(route_nfc_card.router, prefix="/api", tags=["nfc-cards"])
api_router.include_router(route_nfc_transaction.router, prefix="/api", tags=["nfc-transactions"])
api_router.include_router(route_card.router, prefix="/api", tags=["cards"])
api_router.include_router(route_mobile_money.router, prefix="/api", tags=["mobile-money"])
api_router.include_router(route_transfers.router, prefix="/api", tags=["transfers"])
api_router.include_router(route_virtual_card.router, prefix="/api", tags=["virtual-cards"])
api_router.include_router(route_upload_file.router, prefix="/api", tags=["file-upload"])
api_router.include_router(route_admin.router, prefix="/api", tags=["admin"])