# Système de Cartes Physiques NFC - Documentation Complète

## Vue d'ensemble
Ce document décrit l'implémentation complète du système de cartes physiques NFC pour TIM CASH, permettant aux utilisateurs sans smartphone NFC de participer aux transactions.

## Architecture du Système

### 1. Base de Données

#### Table `cards`
```sql
CREATE TABLE cards (
    id VARCHAR(8) PRIMARY KEY,           -- ID unique à 8 chiffres
    uid VARCHAR(50) UNIQUE NOT NULL,     -- UID NFC de la carte
    user_id VARCHAR NOT NULL,            -- ID de l'utilisateur
    status VARCHAR(20) DEFAULT 'active', -- active, blocked, lost, stolen
    created_at TIMESTAMP DEFAULT NOW(),
    updated_at TIMESTAMP
);
```

#### Relations
- `cards.user_id` → `users.id` (Foreign Key)
- Chaque utilisateur peut avoir plusieurs cartes
- Chaque carte appartient à un seul utilisateur

### 2. Backend Services

#### `CardService` - Gestion des cartes
- **`create_card()`** : Créer une nouvelle carte physique
- **`get_user_cards()`** : Récupérer les cartes d'un utilisateur
- **`get_card_by_phone()`** : Trouver une carte par numéro de téléphone
- **`update_card_status()`** : Modifier le statut d'une carte
- **`block_card()`** : Bloquer une carte (perte/vol)
- **`unblock_card()`** : Débloquer une carte
- **`recharge_card_by_phone()`** : Recharger une carte via téléphone (Tim Business)

#### `Card.generate_card_id()` - Génération d'IDs
- Génère des IDs uniques à 8 chiffres
- Vérification d'unicité automatique
- Format numérique uniquement

### 3. API Endpoints

#### Cartes Utilisateur
- `POST /api/cards` - Créer une carte
- `GET /api/cards/my-cards` - Mes cartes
- `GET /api/cards/{card_id}` - Détails d'une carte
- `PUT /api/cards/{card_id}/status` - Modifier le statut
- `POST /api/cards/{card_id}/block` - Bloquer une carte
- `POST /api/cards/{card_id}/unblock` - Débloquer une carte
- `POST /api/cards/recharge` - Recharger une carte

#### Administration
- `GET /api/admin/cards` - Toutes les cartes (admin)
- `GET /api/admin/cards/search` - Rechercher des cartes (admin)

### 4. Interface Admin

#### Page de Gestion des Cartes
- **Localisation** : `/admin/cards`
- **Fonctionnalités** :
  - Liste de toutes les cartes avec filtres
  - Recherche par ID, UID, téléphone, nom
  - Statistiques en temps réel
  - Blocage/déblocage des cartes
  - Recharge de cartes par téléphone
  - Gestion des statuts (active, blocked, lost, stolen)

#### Statistiques Disponibles
- Total des cartes
- Cartes actives
- Cartes bloquées
- Cartes perdues
- Cartes volées

### 5. Application Mobile Flutter

#### Services NFC
- **`NFCCardService`** : Gestion des cartes NFC
- **`NFCTransactionService`** : Transactions NFC

#### Fonctionnalités Utilisateur
- **Liaison de cartes** : Approcher une carte NFC pour la lier
- **Gestion des cartes** : Visualiser, bloquer, délier
- **Transactions NFC** : Paiements et recharges via cartes
- **Désactivation** : Bloquer une carte en cas de perte/vol

#### Interface Utilisateur
- **Écran des cartes** : `/nfc_cards`
- **Bouton principal** : "CARTES NFC" sur l'écran d'accueil
- **Actions disponibles** :
  - Lier une nouvelle carte
  - Définir carte principale
  - Bloquer une carte (perte/vol)
  - Délier une carte

## Workflow Complet

### 1. Liaison d'une Carte
1. Utilisateur appuie sur "CARTES NFC"
2. Appuie sur le bouton "+" pour lier une carte
3. Approche la carte NFC de son téléphone
4. L'application lit l'UID et lie la carte au compte
5. La carte reçoit un ID unique à 8 chiffres

### 2. Rechargement par Tim Business
1. Tim Business accède à l'interface admin
2. Va dans "Cartes NFC" → "Recharger une carte"
3. Saisit le numéro de téléphone du client
4. Indique le montant et la raison
5. Le système trouve la carte du client et recharge son wallet
6. Les commissions sont calculées et appliquées

### 3. Désactivation en Cas de Perte/Vol
#### Côté Utilisateur
1. Utilisateur va dans "Mes Cartes NFC"
2. Sélectionne la carte perdue/volée
3. Appuie sur "Bloquer"
4. Indique la raison (perdue/volée)
5. La carte est immédiatement bloquée

#### Côté Admin
1. Admin accède à "Gestion des Cartes"
2. Recherche la carte par ID, UID ou téléphone
3. Clique sur "Bloquer"
4. Indique la raison du blocage
5. La carte est bloquée dans le système

### 4. Transactions NFC
1. Utilisateur approche sa carte NFC d'un terminal
2. Le terminal lit l'UID de la carte
3. Le système valide la carte (active, non bloquée)
4. La transaction est traitée normalement
5. Les données sont mises à jour en temps réel

## Sécurité et Validation

### Validation des Cartes
- Vérification du statut (active/blocked/lost/stolen)
- Validation de l'UID NFC
- Vérification de la liaison utilisateur
- Contrôle des permissions

### Gestion des Erreurs
- Cartes non trouvées
- Cartes déjà liées
- Utilisateurs non autorisés
- Erreurs de communication NFC

### Audit et Traçabilité
- Historique des changements de statut
- Logs des transactions
- Traçabilité des recharges
- Rapports d'activité

## Avantages du Système

### Pour les Utilisateurs
- **Accessibilité** : Support des utilisateurs sans smartphone NFC
- **Sécurité** : Désactivation immédiate en cas de perte/vol
- **Simplicité** : Interface intuitive pour la gestion
- **Flexibilité** : Plusieurs cartes par utilisateur

### Pour Tim Business
- **Rechargement facile** : Via numéro de téléphone
- **Gestion centralisée** : Interface admin complète
- **Commissions automatiques** : Calcul et application automatiques
- **Traçabilité** : Historique complet des opérations

### Pour l'Administration
- **Contrôle total** : Gestion de toutes les cartes
- **Statistiques** : Tableaux de bord en temps réel
- **Sécurité** : Blocage immédiat des cartes compromises
- **Audit** : Traçabilité complète des opérations

## Migration et Déploiement

### Scripts de Migration
- `migrate_card_system.py` : Création de la table cards
- `test_card_system.py` : Tests du système
- Vérification de l'intégrité des données

### Tests de Validation
- Génération d'IDs uniques
- Liaison de cartes
- Transactions NFC
- Gestion des statuts
- Interface admin
- Application mobile

## Support et Maintenance

### Monitoring
- Surveillance des cartes bloquées
- Alertes de sécurité
- Statistiques d'utilisation
- Performance des transactions

### Maintenance
- Nettoyage des cartes inactives
- Mise à jour des statuts
- Optimisation des performances
- Sauvegarde des données

## Conclusion

Le système de cartes physiques NFC est maintenant complètement opérationnel et offre :

✅ **Support complet** des cartes physiques NFC  
✅ **Interface admin** pour la gestion centralisée  
✅ **Application mobile** avec fonctionnalités complètes  
✅ **Sécurité renforcée** avec désactivation immédiate  
✅ **Rechargement simplifié** pour Tim Business  
✅ **Traçabilité complète** de toutes les opérations  

Le système est prêt pour la production et peut être déployé immédiatement.
